/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Default;
import simulate.DisplayBox;
import simulate.IntegrationIntervalEvent;
import simulate.Integrator;
import simulate.Meter;
import simulate.Simulation;
import simulate.units.Unit;

public abstract class IntegratorMD
extends Integrator {
    protected double timeStep;
    protected Unit.Time timeStepUnit;

    public IntegratorMD() {
        this.setTimeStep(0.001, Default.TIME_STEP_UNIT);
    }

    public ChronoMeter chronoMeter() {
        ChronoMeter c = new ChronoMeter();
        this.addIntegrationIntervalListener(c);
        return c;
    }

    public final double getTimeStep() {
        return this.timeStepUnit.fromSim(this.timeStep);
    }

    public Unit.Time getTimeStepUnit() {
        return this.timeStepUnit;
    }

    public void setTimeStep(double t) {
        this.timeStep = this.timeStepUnit.toSim(t);
    }

    public final void setTimeStep(double t, Unit.Time u) {
        this.timeStepUnit = u;
        this.setTimeStep(t);
    }

    public final void setTimeStepUnit(Unit.Time u) {
        this.timeStepUnit = u;
    }

    public final double timeStep() {
        return this.timeStep;
    }

    class ChronoMeter
    extends Meter {
        double timeSum;

        ChronoMeter() {
            this.reset();
            this.setLabel("Elapsed time");
        }

        public double currentValue() {
            return this.timeSum;
        }

        public void integrationIntervalAction(IntegrationIntervalEvent evt) {
            this.timeSum += (double)IntegratorMD.this.integrationInterval * IntegratorMD.this.timeStep;
        }

        public void reset() {
            this.timeSum = 0.0;
        }
    }

    public static class Timer
    extends DisplayBox {
        public Timer(ChronoMeter meter) {
            this.setMeter(meter);
            this.setUnit(Simulation.unitSystem().time());
            this.setPrecision(7);
            this.setSize(100, 60);
        }
    }
}

