/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import javax.swing.JLabel;
import javax.swing.JTextField;
import simulate.Display;
import simulate.Meter;
import simulate.Phase;
import simulate.Simulation;
import simulate.units.Unit;

public class DisplayBox
extends Display {
    protected JLabel label = new JLabel("Label");
    protected JTextField value = new JTextField("");
    protected Meter meter;
    int precision;
    private boolean useCurrentValue;
    protected Unit unit;

    public DisplayBox() {
        this.value.setEditable(false);
        this.setPrecision(3);
        this.add(this.label);
        this.add(this.value);
        this.unit = Unit.Null.UNIT;
        this.setUseCurrentValue(true);
    }

    public void doUpdate() {
        if (this.useCurrentValue) {
            this.value.setText(DisplayBox.format(this.unit.fromSim(this.meter.mostRecent()), this.precision));
        } else {
            this.value.setText(DisplayBox.format(this.unit.fromSim(this.meter.average()), this.precision));
        }
    }

    public static String format(double d, int precision) {
        if (d == Double.NaN || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return Double.toString(d);
        }
        StringBuffer buffer = new StringBuffer(20);
        if (d < 0.0) {
            d = -d;
            buffer.append('-');
        }
        if (d == 0.0) {
            buffer.append("0.0");
            int p = 0;
            while (p < precision - 1) {
                buffer.append('0');
                ++p;
            }
            return buffer.toString();
        }
        int exponent = 0;
        while (d >= 10.0) {
            ++exponent;
            d /= 10.0;
        }
        while (d < 1.0) {
            --exponent;
            d *= 10.0;
        }
        if (precision < 0) {
            precision = -precision;
        }
        int p = precision;
        while (--p > 0) {
            d *= 10.0;
        }
        long ld = Math.round(d);
        char[] digits = new char[precision];
        p = precision;
        long ld_div_10 = 0L;
        long ld_save = ld;
        while (--p >= 0) {
            ld_div_10 = ld / 10L;
            digits[p] = (char)(48L + (ld - ld_div_10 * 10L));
            ld = ld_div_10;
        }
        if (ld_div_10 > 0L) {
            ld = ld_save / 10L;
            p = precision;
            while (--p >= 0) {
                ld_div_10 = ld / 10L;
                digits[p] = (char)(48L + (ld - ld_div_10 * 10L));
                ld = ld_div_10;
            }
            ++exponent;
        }
        int decimalPoint = 0;
        if (Math.abs(exponent) < 6 || Math.abs(exponent) < precision) {
            while (exponent > 0) {
                ++decimalPoint;
                --exponent;
            }
            while (exponent < 0) {
                --decimalPoint;
                ++exponent;
            }
        }
        if (decimalPoint < 0) {
            buffer.append("0.");
            while (decimalPoint < -1) {
                buffer.append("0");
                ++decimalPoint;
            }
        }
        p = 0;
        while (p < precision) {
            buffer.append(digits[p]);
            if (p == decimalPoint && p < precision - 1) {
                buffer.append(".");
            }
            ++p;
        }
        if (exponent != 0) {
            buffer.append("E" + exponent);
        }
        return buffer.toString();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public int getPrecision() {
        return this.precision;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean getUseCurrentValue() {
        return this.useCurrentValue;
    }

    private void setLabel() {
        String suffix;
        String string = suffix = this.unit.symbol().length() > 0 ? " (" + this.unit.symbol() + ")" : "";
        if (this.meter != null) {
            this.label.setText(String.valueOf(this.meter.getLabel()) + suffix);
        }
    }

    public void setLabel(String s) {
        this.label.setText(s);
    }

    public void setMeter(Meter m) {
        this.meter = m;
        this.setLabel();
    }

    public void setPrecision(int n) {
        this.value.setColumns(n);
        this.precision = n;
    }

    public void setUnit(Unit u) {
        this.unit = u;
        this.setLabel();
    }

    public void setUseCurrentValue(boolean b) {
        this.useCurrentValue = b;
        if (this.meter == null) {
            return;
        }
        if (!this.useCurrentValue && !this.meter.isActive()) {
            System.out.println("Warning: setting to use averages but meter is not active");
        }
    }

    public static class Energy
    extends DisplayBox {
        public Energy(Phase phase) {
            this.setMeter(phase.energy);
            this.setUnit(Simulation.unitSystem().energy());
        }
    }
}

