/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Configuration;
import simulate.Molecule;
import simulate.Simulation;
import simulate.Space;
import simulate.Species;
import simulate.SpeciesWalls;

public class ConfigurationSequential
extends Configuration {
    private boolean fill;

    public ConfigurationSequential() {
        this.setFillVertical(true);
    }

    public boolean getFillVertical() {
        return this.fill;
    }

    public void initializeCoordinates() {
        if (this.parentPhase == null) {
            return;
        }
        double Lx = this.parentPhase.dimensions().component(0);
        double Ly = 0.0;
        if (this.parentPhase.space().D() > 1) {
            Ly = this.parentPhase.dimensions().component(1);
        }
        int sumOfMolecules = 0;
        int j = 0;
        while (j < this.species.size()) {
            Species.Agent s = (Species.Agent)this.species.elementAt(j);
            if (!(s.parentSpecies() instanceof SpeciesWalls)) {
                sumOfMolecules += s.moleculeCount();
            }
            ++j;
        }
        if (sumOfMolecules == 0) {
            return;
        }
        Space.Vector[] rLat = Simulation.D == 1 ? Configuration.lineLattice(sumOfMolecules, Lx) : Configuration.squareLattice(sumOfMolecules, Lx, Ly, this.fill);
        int i = 0;
        int j2 = 0;
        while (j2 < this.species.size()) {
            Species.Agent s = (Species.Agent)this.species.elementAt(j2);
            if (!(s.parentSpecies() instanceof SpeciesWalls)) {
                Molecule m = s.firstMolecule();
                while (m != s.terminationMolecule()) {
                    m.setCOM(rLat[i]);
                    ++i;
                    m = m.nextMolecule();
                }
            }
            ++j2;
        }
        this.initializeMomenta();
    }

    public void setFillVertical(boolean b) {
        this.fill = b;
    }
}

