/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.TextField;
import java.awt.event.MouseEvent;
import simulate.Display;
import simulate.DisplayCanvas;
import simulate.Meter;
import simulate.Phase;
import simulate.Simulation;
import simulate.Space1D;
import simulate.Species;

public class DisplayConfiguration
extends Display {
    public static double SIM2PIXELS = 300.0;
    public static final int LEFT = -1;
    public static final int CENTER = 0;
    public static final int RIGHT = 1;
    public static final int TOP = -1;
    public static final int BOTTOM = 1;
    private final int D = 2;
    private final ConfigurationCanvas canvas = new ConfigurationCanvas();
    public final int[] align = new int[2];
    protected final int[] drawSize = new int[2];
    private boolean drawBoundary = true;
    private boolean drawSpace = false;
    private boolean drawMeters = false;
    private int imageShells = 0;
    protected double scale = 1.0;
    protected final int[] centralOrigin = new int[2];
    public static boolean DRAW_OVERFLOW = false;

    public DisplayConfiguration() {
        this.setSize(300, 300);
        this.align[1] = 0;
        this.align[0] = 0;
        this.add(this.canvas);
        this.setLayout(null);
    }

    protected int computeOrigin(int align, int drawSize, int size) {
        switch (align) {
            case -1: {
                return 0;
            }
            case 0: {
                return (size - drawSize) / 2;
            }
            case 1: {
                return size - drawSize;
            }
        }
        return 0;
    }

    public void doUpdate() {
    }

    public int getAlign(int i) {
        return this.align[i];
    }

    public final boolean getDRAW_OVERFLOW() {
        return DRAW_OVERFLOW;
    }

    public boolean getDrawBoundary() {
        return this.drawBoundary;
    }

    public boolean getDrawMeters() {
        return this.drawMeters;
    }

    public boolean getDrawSpace() {
        return this.drawSpace;
    }

    public int getImageShells() {
        return this.imageShells;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean isMovable() {
        return this.canvas.isMovable();
    }

    public boolean isResizable() {
        return this.canvas.isResizable();
    }

    public void repaint() {
        this.canvas.repaint();
    }

    public void setAlign(int i, int value) {
        this.align[i] = value;
    }

    public final void setDRAW_OVERFLOW(boolean b) {
        DRAW_OVERFLOW = b;
    }

    public void setDrawBoundary(boolean b) {
        this.drawBoundary = b;
    }

    public void setDrawMeters(boolean b) {
        this.drawMeters = b;
    }

    public void setDrawSpace(boolean b) {
        this.drawSpace = b;
    }

    public void setImageShells(int n) {
        if (n >= 0) {
            this.scale *= (double)(2 * this.imageShells + 1) / (double)(2 * n + 1);
            this.imageShells = n;
        }
    }

    public void setMovable(boolean b) {
        this.canvas.setMovable(b);
    }

    public void setPhase(Phase p) {
        super.setPhase(p);
    }

    public void setResizable(boolean b) {
        this.canvas.setResizable(b);
    }

    public void setScale(double s) {
        if (s > 0.0) {
            this.scale = s;
        }
    }

    public class ConfigurationCanvas
    extends DisplayCanvas {
        private boolean writeScale = false;
        private TextField scaleText = new TextField();
        private Font font = new Font("sansserif", 0, 10);
        private int annotationHeight = 12;

        public ConfigurationCanvas() {
            this.scaleText.setVisible(true);
            this.scaleText.setEditable(false);
            this.scaleText.setBounds(0, 0, 100, 50);
        }

        public void changeSize(int w, int h, MouseEvent e) {
            if (e.isControlDown()) {
                double rScale;
                int wh;
                if (w > h) {
                    wh = w;
                    rScale = (double)w / (double)this.getSize().width;
                } else {
                    wh = h;
                    rScale = (double)h / (double)this.getSize().height;
                }
                super.setBounds(this.getLocation().x, this.getLocation().y, wh, wh);
                this.createOffScreen(wh);
                DisplayConfiguration.this.phase.inflate(rScale);
                DisplayConfiguration.this.phase.integrator.initialize();
            } else {
                int x = Math.max(w, h);
                this.setSize(x, x);
                this.createOffScreen(x);
            }
        }

        public void digitTyped(int i) {
            DisplayConfiguration.this.setImageShells(i);
        }

        public void doPaint(Graphics g) {
            if (!this.isVisible() || DisplayConfiguration.this.phase == null) {
                return;
            }
            int w = this.getSize().width;
            int h = this.getSize().height;
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
            double toPixels = DisplayConfiguration.this.scale * SIM2PIXELS;
            DisplayConfiguration.this.drawSize[0] = (int)(toPixels * DisplayConfiguration.this.phase.boundary().dimensions().component(0));
            DisplayConfiguration.this.drawSize[1] = Simulation.D == 1 ? Space1D.drawingHeight : (int)(toPixels * DisplayConfiguration.this.phase.boundary().dimensions().component(1));
            DisplayConfiguration.this.centralOrigin[0] = DisplayConfiguration.this.computeOrigin(DisplayConfiguration.this.align[0], DisplayConfiguration.this.drawSize[0], w);
            DisplayConfiguration.this.centralOrigin[1] = DisplayConfiguration.this.computeOrigin(DisplayConfiguration.this.align[1], DisplayConfiguration.this.drawSize[1], h);
            if (DisplayConfiguration.this.drawBoundary) {
                DisplayConfiguration.this.phase.boundary().draw(g, DisplayConfiguration.this.centralOrigin, DisplayConfiguration.this.scale);
            }
            if (DisplayConfiguration.this.drawSpace) {
                DisplayConfiguration.this.phase.space().draw(g, DisplayConfiguration.this.centralOrigin, DisplayConfiguration.this.scale);
            }
            if (DisplayConfiguration.this.drawMeters) {
                Meter m = DisplayConfiguration.this.phase.firstMeter;
                while (m != null) {
                    m.draw(g, DisplayConfiguration.this.centralOrigin, DisplayConfiguration.this.scale);
                    m = m.nextMeter();
                }
            }
            DisplayConfiguration.this.phase.colorScheme().colorAtoms();
            Species.Agent s = DisplayConfiguration.this.phase.firstSpecies();
            while (s != null) {
                if (s.firstAtom() != null) {
                    s.draw(g, DisplayConfiguration.this.centralOrigin, DisplayConfiguration.this.scale);
                }
                s = s.nextSpecies();
            }
            if (DisplayConfiguration.this.imageShells > 0) {
                double[][] origins = DisplayConfiguration.this.phase.boundary().imageOrigins(DisplayConfiguration.this.imageShells);
                int i = 0;
                while (i < origins.length) {
                    g.copyArea(DisplayConfiguration.this.centralOrigin[0], DisplayConfiguration.this.centralOrigin[1], DisplayConfiguration.this.drawSize[0], DisplayConfiguration.this.drawSize[1], (int)(toPixels * origins[i][0]), (int)(toPixels * origins[i][1]));
                    ++i;
                }
            }
            if (this.writeScale) {
                g.setColor(Color.lightGray);
                g.fillRect(0, this.getSize().height - this.annotationHeight, this.getSize().width, this.annotationHeight);
                g.setColor(Color.black);
                g.setFont(this.font);
                g.drawString("Scale: " + Integer.toString((int)(100.0 * DisplayConfiguration.this.scale)) + "%", 0, this.getSize().height - 3);
            }
        }

        public void letterTyped(char c) {
            switch (c) {
                case 's': {
                    this.writeScale ^= true;
                    break;
                }
                case 'o': {
                    DRAW_OVERFLOW ^= true;
                }
            }
        }

        public void setBounds(int x, int y, int width, int height) {
            if (this.getBounds().width * this.getBounds().height != 0) {
                double ratio1 = (double)width / (double)this.getBounds().width;
                double ratio2 = (double)height / (double)this.getBounds().height;
                double factor = Math.min(ratio1, ratio2);
                DisplayConfiguration.this.scale *= factor;
            }
            super.setBounds(x, y, width, height);
        }
    }
}

