/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.AtomPair;
import simulate.PotentialHard;
import simulate.Simulation;

public class PotentialTether
implements PotentialHard {
    private double tetherLength;
    private double tetherLengthSquared;
    Simulation parentSimulation;

    public PotentialTether() {
        this.setTetherLength(0.1);
    }

    public final void bump(AtomPair pair) {
        double r2 = pair.r2();
        double factor = 2.0 / (pair.atom1().rm() + pair.atom2().rm()) * pair.vDotr() / r2;
        pair.cPair.push(factor);
    }

    public final double collisionTime(AtomPair pair) {
        double r2 = pair.r2();
        double bij = pair.vDotr();
        if (r2 > this.tetherLengthSquared && bij >= 0.0) {
            return 0.0;
        }
        double v2 = pair.v2();
        double discr = bij * bij - v2 * (r2 - this.tetherLengthSquared);
        return (-bij + Math.sqrt(discr)) / v2;
    }

    public double energy(AtomPair pair) {
        return pair.r2() > this.tetherLengthSquared ? Double.MAX_VALUE : 0.0;
    }

    public Simulation getParentSimulation() {
        return this.parentSimulation;
    }

    public final double getTetherLength() {
        return this.tetherLength;
    }

    public boolean overlap(AtomPair pair) {
        return false;
    }

    public void setParentSimulation(Simulation s) {
        this.parentSimulation = s;
    }

    public final void setTetherLength(double t) {
        this.tetherLength = t;
        this.tetherLengthSquared = t * t;
    }
}

