/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.AtomPair;
import simulate.PotentialSoft;
import simulate.Simulation;

public class PotentialLJ
implements PotentialSoft {
    private double sigma;
    private double sigmaSquared;
    private double cutoffDiameter;
    private double cutoffDiameterSquared;
    private double epsilon;
    private double cutoff;
    private double epsilon4;
    private double epsilon24;
    Simulation parentSimulation;

    public PotentialLJ(double sigma, double epsilon, double cutoff) {
        this.setSigma(sigma);
        this.setCutoff(cutoff);
        this.setEpsilon(epsilon);
    }

    public double energy(AtomPair pair) {
        double r2 = pair.r2();
        if (r2 > this.cutoffDiameterSquared) {
            return 0.0;
        }
        double s2 = this.sigmaSquared / r2;
        double s6 = s2 * s2 * s2;
        return this.epsilon4 * s6 * (s6 - 1.0);
    }

    public double getCutoff() {
        return this.cutoff;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public Simulation getParentSimulation() {
        return this.parentSimulation;
    }

    public double getSigma() {
        return this.sigma;
    }

    public boolean overlap(AtomPair pair) {
        return false;
    }

    public void setCutoff(double c) {
        this.cutoff = c;
        this.cutoffDiameter = this.sigma * this.cutoff;
        this.cutoffDiameterSquared = this.cutoffDiameter * this.cutoffDiameter;
    }

    public void setEpsilon(double eps) {
        this.epsilon = eps;
        this.epsilon4 = eps * 4.0;
        this.epsilon24 = eps * 24.0;
    }

    public void setParentSimulation(Simulation s) {
        this.parentSimulation = s;
    }

    public void setSigma(double s) {
        this.sigma = s;
        this.sigmaSquared = s * s;
        this.setCutoff(this.cutoff);
    }

    public double virial(AtomPair pair) {
        double r2 = pair.r2();
        if (r2 > this.cutoffDiameterSquared) {
            return 0.0;
        }
        double s2 = this.sigmaSquared / r2;
        double s6 = s2 * s2 * s2;
        return -this.epsilon24 * s6 * (2.0 * s6 - 1.0);
    }
}

