/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.AtomPair;
import simulate.AtomType;
import simulate.PotentialHard;
import simulate.Simulation;

public class PotentialHardDiskWall
implements PotentialHard {
    protected double collisionDiameter;
    protected double collisionRadius;
    Simulation parentSimulation;

    public PotentialHardDiskWall() {
        this(0.0);
    }

    public PotentialHardDiskWall(double d) {
        this.setCollisionDiameter(d);
    }

    public void bump(AtomPair pair) {
        int i;
        Atom wall;
        Atom disk;
        if (pair.atom2().type instanceof AtomType.Wall) {
            disk = pair.atom1();
            wall = pair.atom2();
        } else {
            disk = pair.atom2;
            wall = pair.atom1;
        }
        AtomType.Wall wallType = (AtomType.Wall)wall.type;
        int n = i = ((AtomType.Wall)wall.type).isHorizontal() ? 1 : 0;
        if (wall.isStationary()) {
            disk.momentum().TE(i, -1.0);
        } else {
            double dv = wall.momentum(i) * wall.rm() - disk.momentum(i) * disk.rm();
            double dp = -2.0 / (wall.rm() + disk.rm()) * dv;
            wall.momentum().PE(i, dp);
            disk.momentum().PE(i, -dp);
        }
    }

    public double collisionTime(AtomPair pair) {
        Atom wall;
        if (pair.atom2().type instanceof AtomType.Wall) {
            Atom disk = pair.atom1();
            wall = pair.atom2();
        } else {
            Atom disk = pair.atom2;
            wall = pair.atom1;
        }
        AtomType.Wall wallType = (AtomType.Wall)wall.type;
        int i = ((AtomType.Wall)wall.type).isHorizontal() ? 1 : 0;
        double dr = pair.dr(i);
        double dv = pair.dv(i);
        return this.timeNoAcceleration(dr, dv);
    }

    public double energy(AtomPair pair) {
        return 0.0;
    }

    public double getCollisionDiameter() {
        return this.collisionDiameter;
    }

    public Simulation getParentSimulation() {
        return this.parentSimulation;
    }

    public boolean overlap(AtomPair pair) {
        return false;
    }

    public void setCollisionDiameter(double c) {
        this.collisionDiameter = c;
        this.collisionRadius = 0.5 * c;
    }

    public void setParentSimulation(Simulation s) {
        this.parentSimulation = s;
    }

    private double timeNoAcceleration(double dr, double dv) {
        if (dr * dv > 0.0) {
            return Double.MAX_VALUE;
        }
        double adr = Math.abs(dr);
        if (adr < this.collisionRadius) {
            return 0.0;
        }
        return (adr - this.collisionRadius) / Math.abs(dv);
    }

    private double timeWithAcceleration(int i, Atom disk, Atom wall) {
        double discrim;
        double time = Double.MAX_VALUE;
        double dr = wall.position(i) - disk.position(i);
        double dv = wall.momentum(i) * wall.rm() - disk.momentum(i) * disk.rm();
        if (Math.abs(dr) < this.collisionRadius) {
            return dr * dv > 0.0 ? Double.MAX_VALUE : 0.0;
        }
        dr += dr > 0.0 ? -this.collisionRadius : this.collisionRadius;
        double a = 0.0;
        if (i == 1) {
            if (!wall.isStationary()) {
                a += wall.parentPhase().getG();
            }
            if (!disk.isStationary()) {
                a -= disk.parentPhase().getG();
            }
        }
        if ((discrim = dv * dv - 2.0 * a * dr) > 0.0) {
            int aSign;
            boolean adr = a * dr > 0.0;
            boolean adv = a * dv > 0.0;
            int n = aSign = a > 0.0 ? 1 : -1;
            if (adr && adv) {
                time = Double.MAX_VALUE;
            } else if (adr) {
                time = (-dv - (double)aSign * Math.sqrt(discrim)) / a;
            } else if (-a * dr / (dv * dv) < 1.0E-7) {
                if (dr * dv < 0.0) {
                    time = -dr / dv * (1.0 + 0.5 * dr * a / (dv * dv));
                }
            } else {
                time = (-dv + (double)aSign * Math.sqrt(discrim)) / a;
            }
        }
        return time;
    }
}

