/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.AtomPair;
import simulate.AtomType;
import simulate.Molecule;
import simulate.Phase;
import simulate.PotentialHardDiskWall;
import simulate.Space;
import simulate.Species;
import simulate.SpeciesDisks;

public class PotentialHardDiskSpeciesSwitchWall
extends PotentialHardDiskWall {
    SpeciesDisks changeSpecies;
    double collisionDiameter;
    double collisionRadius;
    double sig2;

    public PotentialHardDiskSpeciesSwitchWall() {
        this.setCollisionDiameter(0.0);
    }

    public void bump(AtomPair pair) {
        boolean wallFirst;
        Atom wall;
        Atom disk;
        double eps = 1.0E-6;
        if (pair.atom2().type instanceof AtomType.Wall) {
            disk = pair.atom1();
            wall = pair.atom2();
            wallFirst = false;
        } else {
            disk = pair.atom2;
            wall = pair.atom1;
            wallFirst = true;
        }
        Molecule m = disk.parentMolecule;
        Space.Coordinate coord = m.coordinate();
        Phase phase = m.parentPhase();
        phase.deleteMolecule(m);
        m = this.changeSpecies.getMolecule();
        phase.addMolecule(m);
        m.translateTo(coord.position());
        m.accelerateTo(coord.momentum());
        disk = m.firstAtom();
        if (wallFirst) {
            pair.reset(wall, disk);
        } else {
            pair.reset(disk, wall);
        }
        int i = ((AtomType.Wall)wall.type).isHorizontal() ? 1 : 0;
        double dr = pair.dr(i);
        double dv = pair.dv(i);
        if (dr * dv > 0.0) {
            return;
        }
        int sign = dv > 0.0 ? -1 : 1;
        disk.position().PE(i, (double)sign * eps);
    }

    public double energy(AtomPair pair) {
        return 0.0;
    }

    public boolean overlap(AtomPair pair) {
        return false;
    }

    public void setChangeSpecies(Species s) {
        this.changeSpecies = (SpeciesDisks)s;
    }
}

