/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.AtomPair;
import simulate.AtomType;
import simulate.PotentialHard;
import simulate.Simulation;

public class PotentialHardDiskPiston
implements PotentialHard {
    private double collisionDiameter;
    private double collisionRadius;
    Simulation parentSimulation;

    public PotentialHardDiskPiston(double d) {
        this.setCollisionDiameter(d);
    }

    public void bump(AtomPair pair) {
        Atom wall;
        Atom disk;
        if (pair.atom2().type instanceof AtomType.Wall) {
            disk = pair.atom1();
            wall = pair.atom2();
        } else {
            disk = pair.atom2;
            wall = pair.atom1;
        }
        AtomType.Wall wallType = (AtomType.Wall)wall.type;
        int i = wallType.isVertical() ? 0 : (wallType.isHorizontal() ? 1 : 0);
        double dv = wall.momentum(i) * wall.rm() - disk.momentum(i) * disk.rm();
        double dp = -2.0 / (pair.atom1().rm() + pair.atom2().rm()) * dv;
        if (!wall.isStationary()) {
            wall.momentum().PE(i, dp);
        }
        if (!disk.isStationary()) {
            disk.momentum().PE(i, -dp);
        }
        double dr = wall.position(i) - disk.position(i);
        disk.position().PE(i, -1.0E-8 * dr);
    }

    public double collisionTime(AtomPair pair) {
        double a;
        Atom wall;
        Atom disk;
        if (pair.atom2().type instanceof AtomType.Wall) {
            disk = pair.atom1();
            wall = pair.atom2();
        } else {
            disk = pair.atom2;
            wall = pair.atom1;
        }
        double time = Double.MAX_VALUE;
        AtomType.Wall wallType = (AtomType.Wall)wall.type;
        int i = wallType.isVertical() ? 0 : 1;
        double dr = wall.position(i) - disk.position(i);
        if (Math.abs(dr) < this.collisionRadius) {
            return 0.0;
        }
        double d = dr > 0.0 ? -this.collisionRadius : this.collisionRadius;
        double dv = wall.momentum(i) * wall.rm() - disk.momentum(i) * disk.rm();
        double discrim = dv * dv - 2.0 * (a = 0.0) * (dr += d);
        if (discrim > 0.0) {
            int aSign;
            boolean adr = a * dr > 0.0;
            boolean adv = a * dv > 0.0;
            int n = aSign = a > 0.0 ? 1 : -1;
            if (adr && adv) {
                time = Double.MAX_VALUE;
            } else if (adr) {
                time = (-dv - (double)aSign * Math.sqrt(discrim)) / a;
            } else if (-a * dr / (dv * dv) < 1.0E-7) {
                if (dr * dv < 0.0) {
                    time = -dr / dv * (1.0 + 0.5 * dr * a / (dv * dv));
                }
            } else {
                time = (-dv + (double)aSign * Math.sqrt(discrim)) / a;
            }
        }
        return time;
    }

    public double energy(AtomPair pair) {
        return 0.0;
    }

    public double getCollisionDiameter() {
        return this.collisionDiameter;
    }

    public Simulation getParentSimulation() {
        return this.parentSimulation;
    }

    public boolean overlap(AtomPair pair) {
        return false;
    }

    public void setCollisionDiameter(double c) {
        this.collisionDiameter = c;
        this.collisionRadius = 0.5 * c;
    }

    public void setParentSimulation(Simulation s) {
        this.parentSimulation = s;
    }
}

