/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.Beans;
import simulate.Atom;
import simulate.Potential;
import simulate.Potential2;
import simulate.PotentialLJ;

public class P2LennardJones
extends Potential2 {
    private double sigma = 0.1;
    private double epsilon = 300.0;
    private double cutoff = 2.5;
    PotentialLJ onlyPotential = new PotentialLJ(this.sigma, this.epsilon, this.cutoff);

    public P2LennardJones() {
        this.nAtoms1 = 1;
        this.nAtoms2 = 1;
        this.potential = new Potential[1][1];
        this.potential[0][0] = this.onlyPotential;
    }

    public final double getCutoff() {
        return this.cutoff;
    }

    public final double getEpsilon() {
        return this.epsilon;
    }

    public final Potential getPotential(Atom a1, Atom a2) {
        return this.onlyPotential;
    }

    public final double getSigma() {
        return this.sigma;
    }

    public void paint(Graphics g) {
        int[] simulationPixelDimensions = new int[]{-1, -1};
        if (Beans.isDesignTime() && this.getParent() != null) {
            Container par = this.getParent();
            simulationPixelDimensions[0] = par.getSize().width;
            simulationPixelDimensions[1] = par.getSize().height;
            double scale = Math.max(simulationPixelDimensions[0], simulationPixelDimensions[1]);
            int moleculePixelDiameter = (int)(scale * this.sigma);
            g.setColor(Color.red);
            g.fillOval(0, 0, moleculePixelDiameter, moleculePixelDiameter);
        }
    }

    public final void setCutoff(double c) {
        this.cutoff = c;
        this.onlyPotential.setCutoff(c);
    }

    public final void setEpsilon(double eps) {
        this.epsilon = eps;
        this.onlyPotential.setEpsilon(eps);
    }

    public final void setEpsilon(int eps) {
        this.setEpsilon((double)eps);
    }

    public final void setSigma(double s) {
        this.sigma = s;
        this.onlyPotential.setSigma(s);
    }
}

