/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.Molecule;
import simulate.Potential;
import simulate.Potential2;
import simulate.PotentialHardDiskSpeciesSwitchWall;
import simulate.Simulation;
import simulate.Species;

public class P2DiskSpeciesSwitchWall
extends Potential2 {
    int changeSpeciesIndex;

    public P2DiskSpeciesSwitchWall() {
        this.setSize(30, 30);
        this.nAtoms1 = 1;
        this.nAtoms2 = 1;
        this.potential = new Potential[this.nAtoms1][this.nAtoms2];
        this.potential[0][0] = new PotentialHardDiskSpeciesSwitchWall();
        this.setChangeSpeciesIndex(0);
    }

    public final int getChangeSpeciesIndex() {
        return this.changeSpeciesIndex;
    }

    public final Potential getPotential(Atom a1, Atom a2) {
        return this.potential[0][0];
    }

    public final boolean isNeighbor(Molecule m1, Molecule m2) {
        return true;
    }

    public final void setChangeSpeciesIndex(int i) {
        this.changeSpeciesIndex = i;
        Simulation simulation = this.potential[0][0].getParentSimulation();
        if (simulation == null) {
            return;
        }
        Species s = simulation.firstSpecies();
        while (s != null) {
            if (s.getSpeciesIndex() == i) {
                ((PotentialHardDiskSpeciesSwitchWall)this.potential[0][0]).setChangeSpecies(s);
                return;
            }
            s = s.nextSpecies();
        }
    }

    public void setSimulation(Simulation s) {
        super.setSimulation(s);
        this.setChangeSpeciesIndex(this.changeSpeciesIndex);
    }
}

