/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.Constants;
import simulate.IntegrationIntervalEvent;
import simulate.IntegratorHard;
import simulate.Meter;
import simulate.Species;

public class MeterPressure
extends Meter {
    private final double vScale = Constants.SCALE * Constants.SCALE * Constants.SCALE;
    private double momentumSum = 0.0;
    private double timeSum = 0.0;
    double diameter = 0.15;
    public int meterIndex = 0;

    public MeterPressure() {
        this.setLabel("Pressure (bar)");
    }

    public double currentValue() {
        double flux = 0.0;
        int count = 0;
        Species.Agent s = this.phase.firstSpecies();
        while (s != null) {
            if (s.parentSpecies().speciesIndex == this.meterIndex) {
                Atom a = s.firstAtom();
                while (a != s.terminationAtom()) {
                    if (a.ia instanceof IntegratorHard.Agent) {
                        IntegratorHard.Agent ia = (IntegratorHard.Agent)a.ia;
                        flux = 0.5 * ia.pAccumulator * Constants.SCALE / (this.timeSum * Constants.SCALE * Constants.DEPTH);
                        ia.pAccumulator = 0.0;
                        ++count;
                    }
                    a = a.nextAtom();
                }
                this.timeSum = 0.0;
                flux /= (double)count * 0.0060220000000000004;
                break;
            }
            s = s.nextSpecies();
        }
        return flux;
    }

    public int getMeterIndex() {
        return this.meterIndex;
    }

    public void integrationIntervalAction(IntegrationIntervalEvent evt) {
        this.timeSum += evt.integrator.drawTimeStep * (double)evt.integrator.integrationInterval;
        this.updateStatistics(this.phase);
    }

    public void setMeterIndex(int index) {
        this.meterIndex = index;
    }
}

