/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.AtomType;
import simulate.Constants;
import simulate.Meter;
import simulate.Molecule;

public abstract class MeterLocalDensity
extends Meter {
    private final double scaleSquared = Constants.SCALE * Constants.SCALE;
    public static final int ALL_SPECIES = -100;
    int speciesIndex;
    double volume;
    boolean moleFractionMode = false;
    String initialLabel = "Local Density (mol/l)";

    public MeterLocalDensity() {
        this.setLabel(this.initialLabel);
        this.setSpeciesIndex(-100);
        this.computeVolume();
    }

    public abstract void computeVolume();

    public abstract boolean contains(Molecule var1);

    public double currentValue() {
        if (this.moleFractionMode) {
            int totalSum = 0;
            int speciesSum = 0;
            Molecule m = this.phase.firstMolecule();
            while (m != null) {
                if (this.contains(m) && !(m.firstAtom.type instanceof AtomType.Wall)) {
                    ++totalSum;
                    if (m.speciesIndex() == this.speciesIndex) {
                        ++speciesSum;
                    }
                }
                m = m.nextMolecule();
            }
            if (totalSum == 0) {
                return Double.NaN;
            }
            return (double)speciesSum / (double)totalSum;
        }
        int nSum = 0;
        if (this.speciesIndex == -100) {
            Molecule m = this.phase.firstMolecule();
            while (m != null) {
                if (this.contains(m) && !(m.firstAtom.type instanceof AtomType.Wall)) {
                    ++nSum;
                }
                m = m.nextMolecule();
            }
        } else {
            Molecule m = this.phase.firstMolecule();
            while (m != null) {
                if (this.contains(m) && m.speciesIndex() == this.speciesIndex) {
                    ++nSum;
                }
                m = m.nextMolecule();
            }
        }
        return (double)nSum / (this.volume * this.scaleSquared * Constants.DEPTH * 6.022E-4);
    }

    public final boolean getMoleFractionMode() {
        return this.moleFractionMode;
    }

    public final int getSpeciesIndex() {
        return this.speciesIndex;
    }

    public final void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.computeVolume();
    }

    public final void setMoleFractionMode(boolean d) {
        this.moleFractionMode = d;
        if (this.moleFractionMode && this.label.equals(this.initialLabel)) {
            this.setLabel("Mole fraction");
        }
        if (this.moleFractionMode && this.speciesIndex == -100) {
            this.setSpeciesIndex(0);
        }
    }

    public final void setSpeciesIndex(int i) {
        this.speciesIndex = i;
    }
}

