/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.util.Random;
import simulate.MCMove;
import simulate.Phase;
import simulate.Simulation;

public class MCMoveVolume
extends MCMove {
    private final Random rand = new Random();
    double pressure;

    public MCMoveVolume() {
        this.setStepSizeMax(1.0);
        this.setStepSizeMin(0.0);
        this.setStepSize(0.1);
        this.setPressure(0.0);
    }

    public double getPressure() {
        return this.pressure;
    }

    public final void setLogPressure(int lp) {
        this.pressure = Math.pow(10.0, lp);
    }

    public void setPressure(double p) {
        this.pressure = p;
    }

    public void thisTrial(Phase phase) {
        double vOld = phase.volume();
        double hOld = phase.potentialEnergy.currentValue() + this.pressure * vOld * 0.007243204233822469;
        double vScale = (2.0 * this.rand.nextDouble() - 1.0) * this.stepSize;
        double vNew = vOld * Math.exp(vScale);
        double rScale = Math.exp(vScale / (double)Simulation.D);
        phase.inflate(rScale);
        double hNew = phase.potentialEnergy.currentValue() + this.pressure * vNew * 0.007243204233822469;
        if (hNew >= Double.MAX_VALUE || Math.exp(-(hNew - hOld) / this.parentIntegrator.temperature + (double)(phase.moleculeCount + 1) * vScale) < this.rand.nextDouble()) {
            phase.inflate(1.0 / rScale);
        }
        ++this.nAccept;
    }
}

