/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.util.Random;
import simulate.MCMove;
import simulate.Molecule;
import simulate.Phase;
import simulate.Species;

public class MCMoveInsertDelete
extends MCMove {
    private final Random rand = new Random();
    double mu;

    public MCMoveInsertDelete() {
        this.setStepSizeMax(1.0);
        this.setStepSizeMin(0.0);
        this.setStepSize(0.1);
        this.setMu(0.0);
    }

    public final double getMu() {
        return this.mu;
    }

    public final void setMu(double mu) {
        this.mu = mu;
    }

    public final void thisTrial(Phase phase) {
        if (this.rand.nextDouble() < 0.5) {
            this.trialInsert(phase);
        } else {
            this.trialDelete(phase);
        }
    }

    private final void trialDelete(Phase phase) {
        Species.Agent s = phase.firstSpecies();
        if (s.getNMolecules() == 0) {
            return;
        }
        int i = (int)(this.rand.nextDouble() * (double)s.getNMolecules());
        Molecule m = s.firstMolecule;
        int j = i;
        while (--j >= 0) {
            m = m.nextMolecule();
        }
        double bOld = Math.exp((this.mu - phase.potentialEnergy.currentValue(m)) / this.parentIntegrator.temperature);
        double bNew = (double)s.nMolecules / phase.volume();
        if (bNew > bOld || bNew > this.rand.nextDouble() * bOld) {
            phase.deleteMolecule(m);
        }
    }

    private final void trialInsert(Phase phase) {
        Species.Agent s = phase.firstSpecies();
        Molecule m = s.parentSpecies().getMolecule();
        m.translateTo(phase.randomPosition());
        double uNew = phase.potentialEnergy.insertionValue(m);
        if (uNew == Double.MAX_VALUE) {
            return;
        }
        double bNew = Math.exp((this.mu - uNew) / this.parentIntegrator.temperature) * phase.volume() / (double)(s.getNMolecules() + 1);
        if (bNew > 1.0 || bNew > this.rand.nextDouble()) {
            phase.addMolecule(m);
        }
    }
}

