/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.util.Random;
import simulate.Atom;
import simulate.Integrator;
import simulate.MCMove;
import simulate.MCMoveAtom;
import simulate.Molecule;
import simulate.Phase;
import simulate.Simulation;
import simulate.Species;

public class IntegratorGEMC
extends Integrator {
    private final Random rand = new Random();
    public double maxRStep = 0.1;
    public double maxVStep = 0.1;
    public double pressure;
    public double betaMu;
    public double eBetaMu;
    private int freqDisplace = 1;
    private int freqVolume = 1;
    private int freqMolecule = 1;
    private int iDisplace;
    private int iVolume;
    private int iMolecule;
    private int iTotal;
    public Phase secondPhase;
    private MCMove atomDisplace = new MCMoveAtom();

    public IntegratorGEMC() {
        this.phaseCountMax = 2;
        this.phase = new Phase[this.phaseCountMax];
        this.atomDisplace.setAdjustInterval(10000);
        this.atomDisplace.parentIntegrator = this;
    }

    public void doStep(double dummy) {
        int i = (int)(this.rand.nextDouble() * (double)this.iTotal);
        if (i < this.iDisplace) {
            if (this.rand.nextDouble() < 0.5) {
                this.atomDisplace.doTrial(this.firstPhase);
            } else {
                this.atomDisplace.doTrial(this.secondPhase);
            }
        } else if (i < this.iVolume) {
            this.trialVolume();
        } else if (this.rand.nextDouble() < 0.5) {
            this.trialExchange(this.firstPhase, this.secondPhase, this.firstPhase.parentSimulation.firstSpecies);
        } else {
            this.trialExchange(this.secondPhase, this.firstPhase, this.firstPhase.parentSimulation.firstSpecies);
        }
    }

    public final int getFreqDisplace() {
        return this.freqDisplace;
    }

    public final int getFreqMolecule() {
        return this.freqMolecule;
    }

    public final int getFreqVolume() {
        return this.freqVolume;
    }

    public final double getMaxRStep() {
        return this.maxRStep;
    }

    public final double getMaxVStep() {
        return this.maxVStep;
    }

    public void initialize() {
        this.deployAgents();
        this.iDisplace = this.freqDisplace * this.firstPhase.moleculeCount;
        this.iVolume = this.iDisplace + this.freqVolume;
        this.iTotal = this.iMolecule = this.iVolume + this.freqMolecule * this.firstPhase.moleculeCount;
    }

    public Integrator.Agent makeAgent(Atom a) {
        return new Agent(a);
    }

    public void registerPhase(Phase p) {
        super.registerPhase(p);
        if (this.phaseCount > this.phaseCountMax) {
            return;
        }
        if (this.phaseCount == 2) {
            this.secondPhase = this.phase[1];
        }
        System.out.println("phaseCount " + this.phaseCount);
    }

    public final void setFreqDisplace(int f) {
        this.freqDisplace = f;
    }

    public final void setFreqMolecule(int f) {
        this.freqMolecule = f;
    }

    public final void setFreqVolume(int f) {
        this.freqVolume = f;
    }

    public final void setMaxRStep(double s) {
        this.maxRStep = s;
    }

    public final void setMaxVStep(double s) {
        this.maxVStep = s;
    }

    private void trialExchange(Phase iPhase, Phase dPhase, Species species) {
        Species.Agent iSpecies = species.getAgent(iPhase);
        Species.Agent dSpecies = species.getAgent(dPhase);
        if (dSpecies.nMolecules == 0) {
            return;
        }
        Molecule m = dSpecies.randomMolecule();
        double uOld = dPhase.potentialEnergy.currentValue(m);
        m.displaceTo(iPhase.randomPosition());
        double uNew = iPhase.potentialEnergy.insertionValue(m);
        if (uNew == Double.MAX_VALUE) {
            m.replace();
            return;
        }
        double bFactor = (double)dSpecies.nMolecules / dPhase.volume() * iPhase.volume() / (double)(iSpecies.nMolecules + 1) * Math.exp(-(uNew - uOld) / this.temperature);
        if (bFactor > 1.0 || bFactor > this.rand.nextDouble()) {
            iPhase.addMolecule(m, iSpecies);
        } else {
            m.replace();
        }
    }

    private void trialVolume() {
        double v1Old = this.firstPhase.volume();
        double v2Old = this.secondPhase.volume();
        double hOld = this.firstPhase.potentialEnergy.currentValue() + this.secondPhase.potentialEnergy.currentValue();
        double vStep = (2.0 * this.rand.nextDouble() - 1.0) * this.maxVStep;
        double v1New = v1Old + vStep;
        double v2New = v2Old - vStep;
        double v1Scale = v1New / v1Old;
        double v2Scale = v2New / v2Old;
        double r1Scale = Math.pow(v1Scale, 1.0 / (double)Simulation.D);
        double r2Scale = Math.pow(v2Scale, 1.0 / (double)Simulation.D);
        this.firstPhase.inflate(r1Scale);
        this.secondPhase.inflate(r2Scale);
        double hNew = this.firstPhase.potentialEnergy.currentValue() + this.secondPhase.potentialEnergy.currentValue();
        if (hNew >= Double.MAX_VALUE || Math.exp(-(hNew - hOld) / this.temperature + (double)this.firstPhase.moleculeCount * Math.log(v1Scale) + (double)this.secondPhase.moleculeCount * Math.log(v2Scale)) < this.rand.nextDouble()) {
            this.firstPhase.inflate(1.0 / r1Scale);
            this.secondPhase.inflate(1.0 / r2Scale);
        }
    }

    public class Agent
    implements Integrator.Agent {
        public Atom atom;

        public Agent(Atom a) {
            this.atom = a;
        }
    }
}

