/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Graphics;
import simulate.Display;

public class DisplayScrollingGraph
extends Display {
    Color bgColor = new Color(255, 255, 240);
    int margin = 10;
    int number = 0;
    int current = 0;
    int pixels = 300;
    int stepsToGraph = 100;
    boolean useMeterStatistics;
    double[] values = new double[this.stepsToGraph];
    double vMin = -1000.0;
    double vMax = 1000.0;
    String legend = new String("");
    int ticks = 5;
    double[] tickValues;
    double xScale;
    double yScale;
    double vAvg;
    double v2Avg;
    double stdDev;

    public DisplayScrollingGraph() {
        double[] dArray = new double[5];
        dArray[0] = -1000.0;
        dArray[1] = -500.0;
        dArray[3] = 500.0;
        dArray[4] = 1000.0;
        this.tickValues = dArray;
        this.xScale = (double)(this.pixels - 2 * this.margin) / (double)this.stepsToGraph;
        this.yScale = (double)(this.pixels - 2 * this.margin) / (this.vMax - this.vMin);
        this.useMeterStatistics = false;
        this.clear();
    }

    void addValue(double value) {
        if (this.values.length < this.stepsToGraph) {
            double[] temp = this.values;
            this.values = new double[this.stepsToGraph];
            int v = 0;
            while (v < temp.length) {
                this.values[v] = temp[v];
                ++v;
            }
        }
        if (this.number < this.stepsToGraph - 1) {
            ++this.number;
        }
        if (++this.current == this.stepsToGraph) {
            this.current = 0;
        }
        this.values[this.current] = value;
    }

    void clear() {
        this.number = 0;
        this.current = 0;
        int v = 1;
        while (v < this.values.length) {
            this.values[v] = 0.0;
            ++v;
        }
    }

    public void doPaint(Graphics osg) {
        osg.setColor(this.bgColor);
        osg.fillRect(0, 0, this.pixels, this.pixels);
        this.updateStatistics();
        int x = this.margin + (int)((double)this.number * this.xScale);
        int y = this.margin + (int)((this.vMax - this.vAvg) * this.yScale);
        int dy = (int)(this.stdDev * this.yScale);
        osg.setColor(Color.lightGray);
        osg.fillRect(this.margin, y - dy, x - this.margin, 2 * dy);
        osg.setColor(Color.magenta);
        osg.drawLine(this.margin, y, x, y);
        osg.setColor(Color.blue);
        int xOld = 0;
        int yOld = 0;
        int n = 0;
        while (n < this.number) {
            x = this.margin + (int)((double)n * this.xScale);
            y = this.current - this.number + n;
            if (y < 0) {
                y += this.stepsToGraph;
            }
            y = this.margin + (int)((this.vMax - this.values[y]) * this.yScale);
            if (n == 0) {
                osg.drawLine(x, y, x, y);
            } else {
                osg.drawLine(xOld, yOld, x, y);
            }
            xOld = x;
            yOld = y;
            ++n;
        }
        x = this.margin;
        if (this.tickValues != null) {
            int tick = 0;
            while (tick < this.ticks) {
                y = this.margin + (int)((this.vMax - this.tickValues[tick]) * this.yScale);
                osg.setColor(Color.cyan);
                osg.drawLine(this.margin, y, this.pixels - this.margin, y);
                osg.setColor(Color.black);
                osg.drawString(String.valueOf(this.tickValues[tick]), x, y += this.margin / 2);
                ++tick;
            }
        }
        osg.setColor(Color.red);
        osg.drawString(this.legend, this.pixels / 4, this.pixels - this.margin / 2);
    }

    public void doUpdate() {
        this.addValue(this.phase.firstMeter.currentValue());
    }

    public boolean getUseMeterStatistics() {
        return this.useMeterStatistics;
    }

    public void setUseMeterStatistics(boolean b) {
        this.useMeterStatistics = b;
    }

    public void setVMax(double v) {
        this.vMax = v;
        this.yScale = (double)(this.pixels - 2 * this.margin) / (this.vMax - this.vMin);
    }

    public void setVMin(double v) {
        this.vMin = v;
        this.yScale = (double)(this.pixels - 2 * this.margin) / (this.vMax - this.vMin);
    }

    private void updateStatistics() {
        if (this.useMeterStatistics) {
            this.vAvg = this.phase.firstMeter.average();
            this.stdDev = this.phase.firstMeter.error();
        } else {
            this.v2Avg = 0.0;
            this.vAvg = 0.0;
            int n = 0;
            while (n < this.number) {
                this.vAvg += this.values[n];
                this.v2Avg += this.values[n] * this.values[n];
                ++n;
            }
            this.stdDev = 0.0;
            if (this.number > 0) {
                this.vAvg /= (double)this.number;
                this.v2Avg /= (double)this.number;
                this.stdDev = Math.sqrt(this.v2Avg - this.vAvg * this.vAvg);
            }
        }
    }
}

