/*
 * Decompiled with CFR 0.152.
 */
package montecarlo;

public class Histogram {
    private double deltaX;
    private double xMin;
    private double xMax;
    private int nValues;
    private int sum;
    private int[] counts;
    private double[] histogram;
    private double[] xvalues;
    private Plot plot;

    public Histogram(int n, double x0, double x1) {
        this.nValues = n;
        this.xMin = x0;
        this.xMax = x1;
        this.counts = new int[this.nValues];
        this.histogram = new double[this.nValues];
        this.xvalues = new double[n];
        this.deltaX = (x1 - x0) / (double)this.nValues;
        this.reset();
    }

    public void addValue(double x) {
        int i = (int)Math.floor((x - this.xMin) / this.deltaX);
        i = i >= this.nValues ? this.nValues - 1 : i;
        int n = i = i < 0 ? 0 : i;
        this.counts[n] = this.counts[n] + 1;
        ++this.sum;
    }

    public void addValues(double[] x) {
        int j = 0;
        while (j < x.length) {
            this.addValue(x[j]);
            ++j;
        }
    }

    public double[] getHistogram() {
        if (this.sum == 0) {
            return this.histogram;
        }
        int i = 0;
        while (i < this.nValues) {
            this.histogram[i] = (double)this.counts[i] / ((double)this.sum * this.deltaX);
            ++i;
        }
        return this.histogram;
    }

    public Plot getPlot() {
        if (this.plot == null) {
            this.plot = new Plot();
        }
        return this.plot;
    }

    public double[] getX() {
        return this.xvalues;
    }

    public void reset() {
        this.sum = 0;
        int i = 0;
        while (i < this.nValues) {
            this.histogram[i] = 0.0;
            this.counts[i] = 0;
            this.xvalues[i] = this.xMin + ((double)i + 0.5) * this.deltaX;
            ++i;
        }
    }

    public class Plot
    extends ptolemy.plot.Plot {
        public Plot() {
            Histogram.this = Histogram.this;
            this.setTitle("Histogram");
            this.setYRange(0.0, 1.0);
            this.setXRange(Histogram.this.xMin, Histogram.this.xMax);
            this.setImpulses(true);
            this.setMarksStyle("none");
            this.update();
        }

        public void update() {
            this.clear(false);
            this.repaint();
            double[] hist = Histogram.this.getHistogram();
            double[] x = Histogram.this.getX();
            int i = 0;
            while (i < hist.length) {
                this.addPoint(0, x[i], hist[i], false);
                ++i;
            }
            this.repaint();
        }
    }
}

