/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Random;
import montecarlo.DisplayValues;
import montecarlo.Histogram;
import montecarlo.MyRandom;
import montecarlo.Quadrature;
import ptolemy.plot.Plot;
import symantec.itools.lang.Context;

public class MCApplet2
extends Applet {
    Panel panel1 = new Panel();
    Label label1 = new Label();
    TextField inputField = new TextField();
    Button button1 = new Button();
    Button button2 = new Button();
    TextField resultField = new TextField();
    TextField errorField = new TextField();
    Label label2 = new Label();
    Label label3 = new Label();
    Button togglePointsButton = new Button();
    Button toggleHistButton = new Button();
    Panel panel2 = new Panel();
    Panel titlePanel = new Panel();
    Label title = new Label();
    Label label4 = new Label();
    Button button3 = new Button();
    Panel panel3 = new Panel();
    Label label5 = new Label();
    Choice choice1 = new Choice();
    DisplayValues points = new DisplayValues();
    int nPoints = 100;
    Plot integrandPlot = new Plot();
    Plot fwPlot = new Plot();
    Function integrand = new 1(this);
    Function[] integrandArray = new Function[]{new 2(this), new 3(this), new 4(this)};
    Function weight = new 5(this);
    Function uniform = new 6(this);
    Function currentWeight;
    Random rand = new MyRandom(new 7(this));
    Quadrature quad;
    Histogram hist = new Histogram(50, 0.0, 1.0);
    Histogram.Plot histPlot = this.hist.getPlot();
    boolean showHistogram = false;
    boolean showPoints = false;
    boolean showFunction = false;

    void button1_ActionPerformed(ActionEvent actionEvent) {
        this.button1_ActionPerformed_Interaction1(actionEvent);
    }

    void button1_ActionPerformed_Interaction1(ActionEvent actionEvent) {
        try {
            this.quadSimpleMC();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void button2_ActionPerformed(ActionEvent actionEvent) {
        this.button2_ActionPerformed_Interaction1(actionEvent);
    }

    void button2_ActionPerformed_Interaction1(ActionEvent actionEvent) {
        try {
            this.quadImportanceMC();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void button3_ActionPerformed(ActionEvent actionEvent) {
        this.button3_ActionPerformed_Interaction1(actionEvent);
    }

    void button3_ActionPerformed_Interaction1(ActionEvent actionEvent) {
        try {
            this.toggleFunction();
            if (this.showFunction) {
                this.button3.setLabel("Show quadrature");
                return;
            }
            this.button3.setLabel("Show function");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void choice1_ItemStateChanged(ItemEvent itemEvent) {
        this.choice1_ItemStateChanged_Interaction1(itemEvent);
    }

    void choice1_ItemStateChanged_Interaction1(ItemEvent itemEvent) {
        try {
            this.setIntegrand(this.choice1.getSelectedIndex());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private double exact() {
        return 1.0;
    }

    public int getNPoints() {
        return this.nPoints;
    }

    public void init() {
        Context.setApplet(this);
        this.setLayout(null);
        this.setBackground(new Color(153, 153, 102));
        this.setSize(723, 423);
        this.panel1.setLayout(null);
        this.add(this.panel1);
        this.panel1.setBounds(36, 96, 228, 300);
        this.label1.setText("No. of quadrature points");
        this.panel1.add(this.label1);
        this.label1.setForeground(Color.black);
        this.label1.setBounds(0, 12, 132, 24);
        this.panel1.add(this.inputField);
        ((Component)this.inputField).setBackground(new Color(153, 153, 102));
        this.inputField.setBounds(144, 12, 60, 24);
        this.button1.setLabel("Do simple Monte Carlo quadrature");
        this.panel1.add(this.button1);
        this.button1.setBackground(new Color(204, 204, 153));
        this.button1.setForeground(Color.black);
        this.button1.setBounds(0, 60, 225, 37);
        this.button2.setLabel("Do Importance-sampling quadrature");
        this.panel1.add(this.button2);
        this.button2.setBackground(new Color(204, 204, 153));
        this.button2.setForeground(Color.black);
        this.button2.setBounds(0, 108, 225, 37);
        this.resultField.setEditable(false);
        this.panel1.add(this.resultField);
        ((Component)this.resultField).setBackground(new Color(204, 204, 153));
        this.resultField.setBounds(84, 168, 120, 24);
        this.errorField.setEditable(false);
        this.panel1.add(this.errorField);
        ((Component)this.errorField).setBackground(new Color(204, 204, 153));
        this.errorField.setBounds(84, 204, 120, 24);
        this.label2.setText("Result");
        this.label2.setAlignment(2);
        this.panel1.add(this.label2);
        this.label2.setBounds(0, 168, 72, 24);
        this.label3.setText("Error");
        this.label3.setAlignment(2);
        this.panel1.add(this.label3);
        this.label3.setBounds(0, 204, 72, 24);
        this.togglePointsButton.setLabel("Hide points");
        this.panel1.add(this.togglePointsButton);
        this.togglePointsButton.setBackground(new Color(204, 204, 153));
        this.togglePointsButton.setBounds(0, 252, 96, 24);
        this.toggleHistButton.setLabel("Hide histogram");
        this.panel1.add(this.toggleHistButton);
        this.toggleHistButton.setBackground(new Color(204, 204, 153));
        this.toggleHistButton.setBounds(120, 252, 96, 24);
        this.panel2.setLayout(new GridLayout(1, 2, 0, 0));
        this.add(this.panel2);
        this.panel2.setBackground(new Color(153, 102, 102));
        this.panel2.setBounds(276, 108, 432, 216);
        this.titlePanel.setLayout(new GridLayout(2, 1, 0, 0));
        this.add(this.titlePanel);
        this.titlePanel.setBounds(30, 24, 600, 72);
        this.title.setText("Importance-Sampling Monte Carlo Quadrature");
        this.title.setAlignment(1);
        this.titlePanel.add(this.title);
        this.title.setForeground(new Color(153, 0, 0));
        this.title.setFont(new Font("Dialog", 1, 18));
        this.title.setBounds(0, 0, 600, 36);
        this.label4.setText("Evaluating the integral of [exp(x)-1-x^2/2]/[e-13/6] from x = 0 to 1");
        this.label4.setAlignment(1);
        this.titlePanel.add(this.label4);
        this.label4.setFont(new Font("Dialog", 1, 12));
        this.label4.setBounds(0, 36, 600, 36);
        this.button3.setLabel("Show quadrature");
        this.add(this.button3);
        this.button3.setBackground(new Color(204, 204, 153));
        this.button3.setBounds(288, 348, 120, 24);
        this.panel3.setLayout(new GridLayout(2, 1, 0, 0));
        this.add(this.panel3);
        this.panel3.setBounds(492, 348, 120, 51);
        this.label5.setText("Select integrand");
        this.label5.setAlignment(1);
        this.panel3.add(this.label5);
        this.label5.setBounds(0, 0, 120, 25);
        this.choice1.addItem("exp");
        this.choice1.addItem("sin");
        this.choice1.addItem("quadratic");
        try {
            this.choice1.select(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.panel3.add(this.choice1);
        this.choice1.setBackground(new Color(204, 204, 153));
        this.choice1.setBounds(0, 25, 120, 25);
        SymText symText = new SymText();
        this.inputField.addTextListener(symText);
        SymAction symAction = new SymAction();
        this.button1.addActionListener(symAction);
        this.button2.addActionListener(symAction);
        this.togglePointsButton.addActionListener(symAction);
        this.toggleHistButton.addActionListener(symAction);
        this.button3.addActionListener(symAction);
        SymItem symItem = new SymItem();
        this.choice1.addItemListener(symItem);
        this.points.setTitle("Quadrature points");
        this.points.setMaxValues(500);
        this.togglePoints();
        this.toggleHistogram();
        this.setIntegrand(0);
        this.toggleFunction();
        this.setNPoints(100);
        ((TextComponent)this.inputField).setText(new Integer(this.nPoints).toString());
        this.histPlot.setYRange(0.0, 2.5);
        this.integrandPlot.setTitle("Plots of integrand f and weight w");
        this.integrandPlot.addLegend(0, "f");
        this.integrandPlot.addLegend(1, "w");
        this.integrandPlot.addLegend(2, "f/w");
    }

    void inputField_TextValueChanged(TextEvent textEvent) {
        this.inputField_TextValueChanged_Interaction1(textEvent);
    }

    void inputField_TextValueChanged_Interaction1(TextEvent textEvent) {
        try {
            int n = Integer.parseInt(this.inputField.getText());
            if (n <= 1000000) {
                this.setNPoints(n);
                return;
            }
            ((TextComponent)this.inputField).setText(new Integer(1000000).toString());
            this.setNPoints(1000000);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void quadImportanceMC() {
        this.currentWeight = this.weight;
        this.writeResult(this.quad.importanceMC(this.nPoints, this.rand, this.weight));
    }

    public void quadSimpleMC() {
        this.currentWeight = this.uniform;
        this.writeResult(this.quad.simpleMC(this.nPoints));
    }

    public void setIntegrand(int n) {
        this.integrand = this.integrandArray[n];
        this.quad = new Quadrature(this.integrand);
        this.integrandPlot.clear(false);
        this.integrandPlot.repaint();
        this.fwPlot.clear(false);
        this.fwPlot.repaint();
        boolean bl = false;
        int n2 = 1;
        while (n2 < 100) {
            double d = (double)n2 / 99.0;
            double d2 = this.integrand.f(d);
            double d3 = d2 / this.weight.f(d);
            double d4 = this.weight.f(d);
            this.integrandPlot.addPoint(0, d, d2, bl);
            this.integrandPlot.addPoint(1, d, d4, bl);
            this.integrandPlot.addPoint(2, d, d3, bl);
            this.fwPlot.addPoint(0, d, d3, bl);
            bl = true;
            ++n2;
        }
        this.label4.setText("Evaluating the integral of " + this.integrand.toString() + " from x = 0 to 1");
    }

    public void setNPoints(int n) {
        this.nPoints = n;
    }

    private void toggleFunction() {
        if (this.showFunction) {
            this.panel2.remove(this.integrandPlot);
            this.panel2.remove(this.fwPlot);
            this.togglePointsButton.setVisible(true);
            this.toggleHistButton.setVisible(true);
            this.panel2.add(this.points);
            this.panel2.add(this.histPlot);
        } else {
            this.panel2.remove(this.points);
            this.panel2.remove(this.histPlot);
            this.togglePointsButton.setVisible(false);
            this.toggleHistButton.setVisible(false);
            this.panel2.add(this.integrandPlot);
        }
        this.showFunction = !this.showFunction;
    }

    void toggleHistButton_ActionPerformed(ActionEvent actionEvent) {
        this.toggleHistButton_ActionPerformed_Interaction1(actionEvent);
    }

    void toggleHistButton_ActionPerformed_Interaction1(ActionEvent actionEvent) {
        try {
            this.toggleHistogram();
            if (this.showHistogram) {
                this.toggleHistButton.setLabel("Hide histogram");
                return;
            }
            this.toggleHistButton.setLabel("Show histogram");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void toggleHistogram() {
        if (this.showHistogram) {
            this.panel2.remove(this.histPlot);
        } else {
            this.panel2.add(this.histPlot);
        }
        this.panel2.doLayout();
        this.showHistogram = !this.showHistogram;
    }

    private void togglePoints() {
        if (this.showPoints) {
            this.panel2.remove(this.points);
        } else {
            this.panel2.add(this.points);
        }
        this.panel2.doLayout();
        this.showPoints = !this.showPoints;
    }

    void togglePointsButton_ActionPerformed(ActionEvent actionEvent) {
        this.togglePointsButton_ActionPerformed_Interaction1(actionEvent);
    }

    void togglePointsButton_ActionPerformed_Interaction1(ActionEvent actionEvent) {
        try {
            this.togglePoints();
            if (this.showPoints) {
                this.togglePointsButton.setLabel("Hide points");
                return;
            }
            this.togglePointsButton.setLabel("Show points");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void writeResult(double d) {
        ((TextComponent)this.resultField).setText(new Float(d).toString());
        ((TextComponent)this.errorField).setText(new Float(d - 1.0).toString());
        this.points.display(this.quad.getX());
        this.hist.reset();
        this.hist.addValues(this.quad.getX());
        this.histPlot.update();
        this.histPlot.setImpulses(false);
        this.histPlot.addPoint(1, 0.0, this.currentWeight.f(0.0), false);
        this.histPlot.addPoint(1, 1.0, this.currentWeight.f(1.0), true);
        this.histPlot.setImpulses(true);
        this.histPlot.repaint();
    }

    private final class 1
    extends Function {
        /* synthetic */ 1(MCApplet2 mCApplet2) {
        }

        public double f(double d) {
            return (Math.exp(d) - 1.0 - 0.5 * d * d) / (Math.exp(1.0) - 2.1666666666666665);
        }
    }

    private final class 2
    extends Function {
        /* synthetic */ 2(MCApplet2 mCApplet2) {
        }

        public double f(double d) {
            return (Math.exp(d) - 1.0 - 0.5 * d * d) / (Math.exp(1.0) - 2.1666666666666665);
        }

        public String toString() {
            return "[exp(x)-1-x^2/2]/(e-13/6)";
        }
    }

    private final class 3
    extends Function {
        /* synthetic */ 3(MCApplet2 mCApplet2) {
        }

        public double f(double d) {
            return Math.sin(d) / (1.0 - Math.cos(1.0));
        }

        public String toString() {
            return "sin(x)/[1-cos(1)]";
        }
    }

    private final class 4
    extends Function {
        /* synthetic */ 4(MCApplet2 mCApplet2) {
        }

        public double f(double d) {
            return 3.0 * d * d;
        }

        public String toString() {
            return "3x^2";
        }
    }

    private final class 5
    extends Function {
        /* synthetic */ 5(MCApplet2 mCApplet2) {
        }

        public double f(double d) {
            return 2.0 * d;
        }
    }

    private final class 6
    extends Function {
        /* synthetic */ 6(MCApplet2 mCApplet2) {
        }

        public double f(double d) {
            return 1.0;
        }
    }

    private final class 7
    extends Function {
        /* synthetic */ 7(MCApplet2 mCApplet2) {
        }

        public double f(double d) {
            return Math.sqrt(d);
        }
    }

    class Function
    implements montecarlo.Function {
        Function() {
        }

        public double f(double d) {
            return 0.0;
        }

        public String toString() {
            return "function definition";
        }
    }

    class SymText
    implements TextListener {
        SymText() {
        }

        public void textValueChanged(TextEvent textEvent) {
            Object object = textEvent.getSource();
            if (object == MCApplet2.this.inputField) {
                MCApplet2.this.inputField_TextValueChanged(textEvent);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == MCApplet2.this.button1) {
                MCApplet2.this.button1_ActionPerformed(actionEvent);
                return;
            }
            if (object == MCApplet2.this.button2) {
                MCApplet2.this.button2_ActionPerformed(actionEvent);
                return;
            }
            if (object == MCApplet2.this.togglePointsButton) {
                MCApplet2.this.togglePointsButton_ActionPerformed(actionEvent);
                return;
            }
            if (object == MCApplet2.this.toggleHistButton) {
                MCApplet2.this.toggleHistButton_ActionPerformed(actionEvent);
                return;
            }
            if (object == MCApplet2.this.button3) {
                MCApplet2.this.button3_ActionPerformed(actionEvent);
            }
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == MCApplet2.this.choice1) {
                MCApplet2.this.choice1_ItemStateChanged(itemEvent);
            }
        }
    }
}

