/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.Beans;
import simulate.Display;
import simulate.Integrator;
import simulate.Phase;
import simulate.Simulation;

public class Controller
extends Container
implements Runnable {
    protected Integrator integrator;
    protected Integrator firstIntegrator;
    public Phase phase;
    public Simulation parentSimulation;
    Thread runner;
    private boolean initialized = false;
    private int maxSteps;

    public Controller() {
        this.setSize(100, 40);
        this.maxSteps = Integer.MAX_VALUE;
    }

    public void add(Integrator i) {
        this.integrator = i;
        i.nextIntegrator = this.firstIntegrator;
        this.firstIntegrator = i;
        i.parentController = this;
        Phase p = this.parentSimulation.firstPhase();
        while (p != null) {
            if (p.integrator == null && i.wantsPhase()) {
                i.registerPhase(p);
                p.gravity.addObserver(i);
                p.integrator = i;
            }
            p = p.nextPhase();
        }
        Display d = this.parentSimulation.firstDisplay;
        while (d != null) {
            i.addIntegrationIntervalListener(d);
            d = d.nextDisplay();
        }
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public Integrator integrator() {
        return this.integrator;
    }

    public void paint(Graphics g) {
        if (Beans.isDesignTime()) {
            g.setColor(Color.red);
            g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            g.drawRect(1, 1, this.getSize().width - 3, this.getSize().height - 3);
        }
        g.setColor(this.getBackground());
        this.paintComponents(g);
    }

    public void run() {
        this.integrator.initialize();
        this.integrator.run();
    }

    public void setMaxSteps(int m) {
        this.maxSteps = m;
    }

    public void start() {
        this.runner = new Thread(this);
        this.runner.start();
    }
}

