/*
 * Decompiled with CFR 0.152.
 */
package simulate.units;

import simulate.units.Amu;
import simulate.units.Angstrom;
import simulate.units.Picosecond;

public abstract class Unit {
    public abstract double fromSim(double var1);

    public abstract String symbol();

    public abstract double toSim(double var1);

    public abstract String toString();

    public static interface D2 {
        public static final double FALSE_DEPTH = 5.0;
    }

    public static interface D3 {
    }

    public static class Null
    extends Unit {
        public static final Null UNIT = new Null();

        public double fromSim(double x) {
            return x;
        }

        public String symbol() {
            return "";
        }

        public double toSim(double x) {
            return x;
        }

        public String toString() {
            return "dimensionless";
        }
    }

    public static abstract class Mass
    extends Unit {
        public double from(Mass u, double x) {
            return u.toSim(this.fromSim(x));
        }

        public double to(Mass u, double x) {
            return u.fromSim(this.toSim(x));
        }

        public static final class Sim
        extends Mass {
            public static final Mass UNIT = Amu.UNIT;

            public double fromSim(double x) {
                return x;
            }

            public String symbol() {
                return UNIT.symbol();
            }

            public double toSim(double x) {
                return x;
            }

            public String toString() {
                return UNIT.toString();
            }
        }
    }

    public static abstract class Length
    extends Unit {
        public double from(Length u, double x) {
            return u.toSim(this.fromSim(x));
        }

        public double to(Length u, double x) {
            return u.fromSim(this.toSim(x));
        }

        public static final class Sim
        extends Length {
            public static final Length UNIT = Angstrom.UNIT;

            public double fromSim(double x) {
                return x;
            }

            public String symbol() {
                return UNIT.symbol();
            }

            public double toSim(double x) {
                return x;
            }

            public String toString() {
                return UNIT.toString();
            }
        }
    }

    public static abstract class Time
    extends Unit {
        public double from(Time u, double x) {
            return u.toSim(this.fromSim(x));
        }

        public double to(Time u, double x) {
            return u.fromSim(this.toSim(x));
        }

        public static final class Sim
        extends Time {
            public static final Time UNIT = Picosecond.UNIT;

            public double fromSim(double x) {
                return x;
            }

            public String symbol() {
                return UNIT.symbol();
            }

            public double toSim(double x) {
                return x;
            }

            public String toString() {
                return UNIT.toString();
            }
        }
    }

    public static abstract class Charge
    extends Unit {
        public double from(Time u, double x) {
            return u.toSim(this.fromSim(x));
        }

        public double to(Time u, double x) {
            return u.fromSim(this.toSim(x));
        }

        public static final class Sim
        extends Charge {
            public static final Charge UNIT = new Sim();

            public double fromSim(double x) {
                return x;
            }

            public String symbol() {
                return "(amu-A^3/ps^2)^(1/2)";
            }

            public double toSim(double x) {
                return x;
            }

            public String toString() {
                return "sim units";
            }
        }
    }

    public static abstract class Energy
    extends Unit {
        public double from(Energy u, double x) {
            return u.toSim(this.fromSim(x));
        }

        public double to(Energy u, double x) {
            return u.fromSim(this.toSim(x));
        }

        public static final class Sim
        extends Energy {
            public static final Energy UNIT = new Sim();

            public double fromSim(double x) {
                return x;
            }

            public String symbol() {
                return "amu-A^2/ps^2";
            }

            public double toSim(double x) {
                return x;
            }

            public String toString() {
                return "sim units";
            }
        }
    }

    public static abstract class Temperature
    extends Energy {

        public static final class Sim
        extends Temperature {
            public static final Temperature UNIT = new Sim();

            public double fromSim(double x) {
                return x;
            }

            public String symbol() {
                return "kB amu-A^2/ps^2";
            }

            public double toSim(double x) {
                return x;
            }

            public String toString() {
                return "times kB, sim units";
            }
        }
    }

    public static abstract class Pressure
    extends Unit {
        public double from(Pressure u, double x) {
            return u.toSim(this.fromSim(x));
        }

        public double to(Pressure u, double x) {
            return u.fromSim(this.toSim(x));
        }

        public static final class Sim
        extends Pressure {
            public static final Pressure UNIT = new Sim();

            public double fromSim(double x) {
                return x;
            }

            public String symbol() {
                return "amu/(A-ps^2)";
            }

            public double toSim(double x) {
                return x;
            }

            public String toString() {
                return "sim units";
            }
        }
    }

    public static abstract class Pressure2D
    extends Pressure
    implements D2 {
        public double from(Pressure u, double x) {
            return u instanceof D3 ? u.toSim(this.fromSim(x * 5.0)) : u.toSim(this.fromSim(x));
        }

        public double to(Pressure u, double x) {
            return u instanceof D3 ? u.fromSim(this.toSim(x / 5.0)) : u.fromSim(this.toSim(x));
        }

        public static final class Sim
        extends Pressure2D {
            public static final Pressure2D UNIT = new Sim();

            public double fromSim(double x) {
                return x;
            }

            public String symbol() {
                return "amu/ps^2";
            }

            public double toSim(double x) {
                return x;
            }

            public String toString() {
                return "sim units";
            }
        }
    }

    public static abstract class Volume
    extends Unit {
        public double from(Volume u, double x) {
            return u.toSim(this.fromSim(x));
        }

        public double to(Volume u, double x) {
            return u.fromSim(this.toSim(x));
        }

        public static final class Sim
        extends Volume {
            public static final Volume UNIT = new Sim();

            public double fromSim(double x) {
                return x;
            }

            public String symbol() {
                return "A^3";
            }

            public double toSim(double x) {
                return x;
            }

            public String toString() {
                return "sim units";
            }
        }
    }

    public static abstract class Volume2D
    extends Volume
    implements D2 {
        public double from(Volume u, double x) {
            return u instanceof D3 ? u.toSim(this.fromSim(x / 5.0)) : u.toSim(this.fromSim(x));
        }

        public double to(Volume u, double x) {
            return u instanceof D3 ? u.fromSim(this.toSim(x * 5.0)) : u.fromSim(this.toSim(x));
        }

        public static final class Sim
        extends Volume2D {
            public static final Volume2D UNIT = new Sim();

            public double fromSim(double x) {
                return x;
            }

            public String symbol() {
                return "A^2";
            }

            public double toSim(double x) {
                return x;
            }

            public String toString() {
                return "sim units";
            }
        }
    }
}

