/*
 * Decompiled with CFR 0.152.
 */
package simulate.electrostatics;

import simulate.Atom;
import simulate.AtomPair;
import simulate.MeterFunction;
import simulate.Phase;
import simulate.Simulation;
import simulate.Space2D;
import simulate.electrostatics.ElectroType;

public class LatticeSum
extends MeterFunction {
    AtomPair.Iterator.All iteratorAll;
    Atom.Iterator atomIterator;
    private double z2Sum;

    private void cubic() {
        double peSum;
        this.atomIterator.reset();
        this.z2Sum = 0.0;
        while (this.atomIterator.hasNext()) {
            Atom a = this.atomIterator.next();
            double z = ((ElectroType.Monopole)a.type.electroType()).z();
            this.z2Sum += z * z;
        }
        this.phase.parentSimulation();
        Space2D.Vector M = (Space2D.Vector)Simulation.space.makeVector();
        double L = this.phase.boundary().dimensions().component(0);
        this.y[0] = peSum = this.energy(M);
        int m = 1;
        while (m < this.nPoints) {
            M.x = (double)m * L;
            M.y = (double)m * L;
            peSum += this.energy(M);
            M.x = (double)(-m) * L;
            peSum += this.energy(M);
            M.y = (double)(-m) * L;
            peSum += this.energy(M);
            M.x = (double)m * L;
            peSum += this.energy(M);
            int i = -m + 1;
            while (i < m) {
                M.x = (double)m * L;
                M.y = (double)i * L;
                peSum += this.energy(M);
                M.x = (double)(-m) * L;
                peSum += this.energy(M);
                M.x = (double)i * L;
                M.y = (double)m * L;
                peSum += this.energy(M);
                M.y = (double)(-m) * L;
                peSum += this.energy(M);
                ++i;
            }
            this.y[m] = peSum;
            ++m;
        }
    }

    public double[] currentValue() {
        this.cubic();
        return this.y;
    }

    private double energy(Space2D.Vector M) {
        double pe = 0.0;
        this.iteratorAll.reset();
        double m2 = M.squared();
        while (this.iteratorAll.hasNext()) {
            double energy;
            AtomPair pair = this.iteratorAll.next();
            if (m2 > 0.0) {
                ((Space2D.CoordinatePair)pair.cPair).reset(M);
            }
            if ((energy = this.phase.parentSimulation().getPotential(pair).energy(pair)) == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            pe += energy;
        }
        double self = m2 > 0.0 ? this.z2Sum / Math.sqrt(m2) : 0.0;
        return 2.0 * pe + self;
    }

    public void setNPoints(int n) {
        this.setX(-0.5, (double)n - 0.5, n);
    }

    public void setPhase(Phase p) {
        super.setPhase(p);
        this.iteratorAll = p.iterator.makeAtomPairIteratorAll();
        this.atomIterator = p.iterator.makeAtomIteratorUp();
    }
}

