/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Component;
import java.awt.Graphics;
import simulate.Atom;
import simulate.Molecule;
import simulate.Potential;
import simulate.Simulation;

public abstract class Potential2
extends Component {
    int species1Index = 0;
    int species2Index = 0;
    public Potential[][] potential;
    public int nAtoms1;
    public int nAtoms2;
    double skinThickness;
    double potentialCutoff;
    double neighborRadius = Double.MAX_VALUE;
    double squareNeighborRadius;

    public Potential2() {
        this.potentialCutoff = Double.MAX_VALUE;
        this.setSize(60, 60);
    }

    public final double getNeighborRadius() {
        return this.neighborRadius;
    }

    public abstract Potential getPotential(Atom var1, Atom var2);

    public final double getSkinThickness() {
        return this.skinThickness;
    }

    public int getSpecies1Index() {
        return this.species1Index;
    }

    public int getSpecies2Index() {
        return this.species2Index;
    }

    public boolean isNeighbor(Molecule m1, Molecule m2) {
        return true;
    }

    public void paint(Graphics g) {
    }

    public final void setPotentialCutoff(double d) {
        this.potentialCutoff = d;
        this.setSkinThickness(this.skinThickness);
    }

    public void setSimulation(Simulation s) {
        int i1 = 0;
        while (i1 < this.nAtoms1) {
            int i2 = 0;
            while (i2 < this.nAtoms2) {
                this.potential[i1][i2].setParentSimulation(s);
                ++i2;
            }
            ++i1;
        }
    }

    public final void setSkinThickness(double s) {
        this.skinThickness = s;
        this.neighborRadius = this.potentialCutoff + this.skinThickness;
        this.squareNeighborRadius = this.neighborRadius * this.neighborRadius;
    }

    public void setSpecies1Index(int index) {
        this.species1Index = index;
    }

    public void setSpecies2Index(int index) {
        this.species2Index = index;
    }
}

