/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.Beans;
import simulate.Atom;
import simulate.Default;
import simulate.Potential;
import simulate.Potential2;
import simulate.PotentialPrimitive;
import simulate.units.Unit;

public class P2Primitive
extends Potential2 {
    private double sigma;
    private Unit.Length sigmaUnit;
    private double cutoff = 2.5;
    PotentialPrimitive onlyPotential = new PotentialPrimitive(this.sigma, this.cutoff);

    public P2Primitive() {
        this.nAtoms1 = 1;
        this.nAtoms2 = 1;
        this.potential = new Potential[1][1];
        this.potential[0][0] = this.onlyPotential;
        this.setSigma(3.0, Default.ATOM_SIZE_UNIT);
    }

    public final double getCutoff() {
        return this.cutoff;
    }

    public final Potential getPotential(Atom a1, Atom a2) {
        return this.onlyPotential;
    }

    public final double getSigma() {
        return this.sigmaUnit.fromSim(this.sigma);
    }

    public Unit.Length getSigmaUnit() {
        return this.sigmaUnit;
    }

    public void paint(Graphics g) {
        int[] simulationPixelDimensions = new int[]{-1, -1};
        if (Beans.isDesignTime() && this.getParent() != null) {
            Container par = this.getParent();
            simulationPixelDimensions[0] = par.getSize().width;
            simulationPixelDimensions[1] = par.getSize().height;
            double scale = Math.max(simulationPixelDimensions[0], simulationPixelDimensions[1]);
            int moleculePixelDiameter = (int)(scale * this.sigma);
            g.setColor(Color.red);
            g.fillOval(0, 0, moleculePixelDiameter, moleculePixelDiameter);
        }
    }

    public final void setCutoff(double c) {
        this.cutoff = c;
        this.onlyPotential.setCutoff(c);
    }

    public final void setSigma(double d) {
        this.sigma = this.sigmaUnit.toSim(d);
        this.onlyPotential.setSigma(this.sigma);
    }

    public final void setSigma(double d, Unit.Length u) {
        this.sigmaUnit = u;
        this.setSigma(d);
    }

    public final void setSigmaUnit(Unit.Length u) {
        this.sigmaUnit = u;
    }

    public final double sigma() {
        return this.sigma;
    }
}

