/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.MeterAbstract;

public abstract class MeterFunction
extends MeterAbstract {
    protected double[] x;
    protected double[] y;
    protected double[] average;
    protected double[] error;
    protected int nPoints = 0;
    protected double xMin;
    protected double xMax;
    protected String xLabel;
    protected MeterAbstract.Accumulator[] accumulator;

    public MeterFunction() {
        this.setX(0.0, 1.0, 100);
        this.setXLabel("x");
        this.setActive(false);
    }

    public double[] X() {
        return this.x;
    }

    public double[] average() {
        int i = 0;
        while (i < this.nPoints) {
            this.average[i] = this.accumulator[i].average();
            ++i;
        }
        return this.average;
    }

    public abstract double[] currentValue();

    public double[] error() {
        int i = 0;
        while (i < this.nPoints) {
            this.error[i] = this.accumulator[i].error();
            ++i;
        }
        return this.error;
    }

    public int getNPoints() {
        return this.nPoints;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public void reset() {
        int i = 0;
        while (i < this.nPoints) {
            this.accumulator[i].reset();
            ++i;
        }
    }

    public void setActive(boolean b) {
        super.setActive(b);
        if (this.active) {
            this.setX(this.xMin, this.xMax, this.nPoints);
        }
    }

    public void setNPoints(int n) {
        this.setX(this.xMin, this.xMax, n);
    }

    public void setX(double min, double max, int n) {
        if (n != this.nPoints) {
            this.nPoints = n;
            this.x = new double[n];
            this.y = new double[n];
            if (this.active) {
                this.average = new double[n];
                this.error = new double[n];
                this.accumulator = new MeterAbstract.Accumulator[n];
                int i = 0;
                while (i < n) {
                    this.accumulator[i] = new MeterAbstract.Accumulator();
                    ++i;
                }
            }
        }
        this.xMin = min;
        this.xMax = max;
        double dx = (this.xMax - this.xMin) / (double)this.nPoints;
        int i = 0;
        while (i < this.nPoints) {
            this.x[i] = this.xMin + ((double)i + 0.5) * dx;
            ++i;
        }
    }

    public void setXLabel(String s) {
        this.xLabel = s;
    }

    public void setXMax(double xm) {
        this.setX(this.xMin, xm, this.nPoints);
    }

    public void setXMin(double xm) {
        this.setX(xm, this.xMax, this.nPoints);
    }

    public void updateSums() {
        double[] values = this.currentValue();
        int i = 0;
        while (i < this.nPoints) {
            this.accumulator[i].add(values[i]);
            ++i;
        }
    }
}

