/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.util.Random;
import simulate.Atom;
import simulate.MCMove;
import simulate.Phase;

public class MCMoveAtom
extends MCMove {
    private final Random rand = new Random();

    public MCMoveAtom() {
        this.setStepSizeMax(30.0);
        this.setStepSizeMin(0.0);
        this.setStepSize(3.0);
    }

    public void thisTrial(Phase phase) {
        if (phase.atomCount == 0) {
            return;
        }
        int i = (int)(this.rand.nextDouble() * (double)phase.atomCount);
        Atom a = phase.firstAtom();
        int j = i;
        while (--j >= 0) {
            a = a.nextAtom();
        }
        double uOld = phase.potentialEnergy.currentValue(a);
        a.displaceWithin(this.stepSize);
        phase.boundary().centralImage(a.coordinate.position());
        phase.iterator.moveNotify(a);
        double uNew = phase.potentialEnergy.currentValue(a);
        if (uNew < uOld) {
            ++this.nAccept;
            return;
        }
        if (uNew >= Double.MAX_VALUE || Math.exp(-(uNew - uOld) / this.parentIntegrator.temperature) < this.rand.nextDouble()) {
            a.replace();
            phase.iterator.moveNotify(a);
            return;
        }
        ++this.nAccept;
    }
}

