/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.util.Random;
import simulate.Atom;
import simulate.Integrator;
import simulate.MCMove;

public class IntegratorMC
extends Integrator {
    private final Random rand = new Random();
    private MCMove firstMove;
    private MCMove lastMove;
    private int frequencyTotal;
    private transient MCMove trialMove;

    public void add(MCMove move) {
        if (this.firstMove == null) {
            this.firstMove = move;
        } else {
            this.lastMove.setNextMove(move);
        }
        this.lastMove = move;
        move.parentIntegrator = this;
    }

    public void doStep() {
        int i = (int)(this.rand.nextDouble() * (double)this.frequencyTotal);
        this.trialMove = this.firstMove;
        while ((i -= this.trialMove.getFrequency()) >= 0) {
            this.trialMove = this.trialMove.nextMove();
        }
        this.trialMove.doTrial(this.firstPhase);
    }

    public void initialize() {
        this.deployAgents();
        this.frequencyTotal = 0;
        MCMove m = this.firstMove;
        while (m != null) {
            m.resetFrequency(this.firstPhase);
            this.frequencyTotal += m.getFrequency();
            m = m.nextMove();
        }
    }

    public Integrator.Agent makeAgent(Atom a) {
        return new Agent(a);
    }

    public class Agent
    implements Integrator.Agent {
        public Atom atom;

        public Agent(Atom a) {
            this.atom = a;
        }
    }
}

