/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Display;
import simulate.MeterFunction;
import simulate.MeterMultiFunction;
import simulate.units.Unit;

public class DisplayPlot
extends Display {
    Plot plot = new Plot();
    MeterFunction meter;
    Unit xUnit;
    Unit yUnit;
    boolean useCurrentValue;

    public DisplayPlot() {
        this.add(this.plot);
        this.setXUnit(Unit.Null.UNIT);
        this.setYUnit(Unit.Null.UNIT);
        this.setUseCurrentValue(false);
    }

    public void doUpdate() {
        this.plot.clear(false);
        if (this.meter instanceof MeterMultiFunction) {
            MeterMultiFunction m = (MeterMultiFunction)this.meter;
            int f = 0;
            while (f < m.nFunctions()) {
                double[] x = m.X(f);
                double[] y = this.useCurrentValue ? m.currentValue(f) : m.average(f);
                int i = 0;
                while (i < x.length) {
                    this.plot.addPoint(f, this.xUnit.fromSim(x[i]), this.yUnit.fromSim(y[i]), true);
                    ++i;
                }
                ++f;
            }
        } else {
            double[] x = this.meter.X();
            double[] y = this.useCurrentValue ? this.meter.currentValue() : this.meter.average();
            int i = 0;
            while (i < x.length) {
                this.plot.addPoint(0, this.xUnit.fromSim(x[i]), this.yUnit.fromSim(y[i]), true);
                ++i;
            }
        }
        this.plot.repaint();
    }

    public boolean getConnected() {
        return this.plot.getConnected();
    }

    public boolean getUseCurrentValue() {
        return this.useCurrentValue;
    }

    public Unit getXUnit() {
        return this.xUnit;
    }

    public Unit getYUnit() {
        return this.yUnit;
    }

    public void setConnected(boolean b) {
        this.plot.setConnected(b);
    }

    public void setMeter(MeterFunction m) {
        this.meter = m;
        this.plot.setXLabel(String.valueOf(this.meter.getXLabel()) + " (" + this.xUnit.symbol() + ")");
        this.plot.setYLabel(this.meter.getLabel());
        this.setUseCurrentValue(this.getUseCurrentValue());
        if (m instanceof MeterMultiFunction) {
            int nF = ((MeterMultiFunction)m).nFunctions();
            int f = 0;
            while (f < nF) {
                MeterFunction m1 = ((MeterMultiFunction)m).meter(f);
                this.plot.addLegend(f, m1.getLabel());
                ++f;
            }
        }
    }

    public void setUseCurrentValue(boolean b) {
        this.useCurrentValue = b;
        if (this.meter == null) {
            return;
        }
        if (!this.useCurrentValue && !this.meter.isActive()) {
            System.out.println("Warning: setting to use averages but meter is not active");
        }
    }

    public void setXUnit(Unit u) {
        this.xUnit = u;
    }

    public void setYUnit(Unit u) {
        this.yUnit = u;
    }

    public class Plot
    extends ptolemy.plot.Plot {
    }
}

