/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Component;
import java.util.Random;
import java.util.Vector;
import simulate.Atom;
import simulate.Default;
import simulate.Molecule;
import simulate.Phase;
import simulate.Simulation;
import simulate.Space;
import simulate.Space1D;
import simulate.Space2D;
import simulate.Species;
import simulate.SpeciesWalls;
import simulate.units.Unit;

public abstract class Configuration
extends Component {
    protected Vector species = new Vector();
    protected double temperature;
    protected Unit.Temperature temperatureUnit;
    Phase parentPhase;
    Random rand = new Random();
    public static final boolean HORIZONTAL = false;
    public static final boolean VERTICAL = true;

    public Configuration() {
        this.setTemperature(300.0, Default.TEMPERATURE_UNIT);
    }

    public Configuration(Species.Agent s) {
        this();
        this.species.addElement(s);
        this.initializeCoordinates();
    }

    public void add(Species.Agent s) {
        this.species.addElement(s);
        if (s.getNMolecules() > 0) {
            this.initializeCoordinates();
        }
    }

    public final double getTemperature() {
        return this.temperatureUnit.fromSim(this.temperature);
    }

    public Unit.Temperature getTemperatureUnit() {
        return this.temperatureUnit;
    }

    public abstract void initializeCoordinates();

    public void initializeMomenta() {
        Simulation cfr_ignored_0 = this.parentPhase.parentSimulation;
        Space.Vector momentumSum = Simulation.space.makeVector();
        int sum = 0;
        int j = 0;
        while (j < this.species.size()) {
            Species.Agent s = (Species.Agent)this.species.elementAt(j);
            if (!(s.parentSpecies() instanceof SpeciesWalls)) {
                Atom a = s.firstAtom();
                while (a != s.terminationAtom()) {
                    a.randomizeMomentum(this.temperature);
                    ++sum;
                    momentumSum.PE(a.coordinate.momentum());
                    a = a.nextAtom();
                }
            }
            ++j;
        }
        momentumSum.DE(sum);
        int j2 = 0;
        while (j2 < this.species.size()) {
            Species.Agent s = (Species.Agent)this.species.elementAt(j2);
            if (!(s.parentSpecies() instanceof SpeciesWalls)) {
                Atom a = s.firstAtom();
                while (a != s.terminationAtom()) {
                    a.coordinate.momentum().ME(momentumSum);
                    a = a.nextAtom();
                }
            }
            ++j2;
        }
    }

    public void initializeMomentum(Molecule m) {
        m.randomizeMomentum(this.temperature);
    }

    public static Space1D.Vector[] lineLattice(int n, double Lx) {
        Space1D.Vector[] r = new Space1D.Vector[n];
        double delta = Lx / (double)n;
        int i = 0;
        while (i < n) {
            r[i] = new Space1D.Vector();
            r[i].x = ((double)i + 0.5) * delta;
            ++i;
        }
        return r;
    }

    public final void setTemperature(double t) {
        this.temperature = this.temperatureUnit.toSim(t);
    }

    public final void setTemperature(double t, Unit.Temperature u) {
        this.temperatureUnit = u;
        this.setTemperature(t);
    }

    public final void setTemperatureUnit(Unit.Temperature u) {
        this.temperatureUnit = u;
    }

    public static Space2D.Vector[] squareLattice(int n, double Lx, double Ly, boolean fillVertical) {
        Space2D.Vector[] r = new Space2D.Vector[n];
        int i = 0;
        while (i < n) {
            r[i] = new Space2D.Vector();
            ++i;
        }
        int moleculeColumns = (int)Math.sqrt(Lx / Ly * (double)n);
        int moleculeRows = n / moleculeColumns;
        if (moleculeRows * moleculeColumns < n) {
            ++moleculeRows;
        }
        int columnsDrawn = (int)((double)n / (double)moleculeRows - 1.0E-10) + 1;
        double moleculeColumnsShift = Lx / (double)columnsDrawn / 2.0;
        double moleculeRowsShift = Ly / (double)moleculeRows / 2.0;
        double moleculeInitialSpacingX = Lx / (double)columnsDrawn;
        double moleculeInitialSpacingY = Ly / (double)moleculeRows;
        int i2 = 0;
        int ix = 0;
        int iy = 0;
        while (i2 < n) {
            r[i2].x = (double)ix * moleculeInitialSpacingX + moleculeColumnsShift;
            r[i2].y = (double)iy * moleculeInitialSpacingY + moleculeRowsShift;
            ++i2;
            if (fillVertical) {
                if (++iy < moleculeRows) continue;
                iy = 0;
                ++ix;
                continue;
            }
            if (++ix < columnsDrawn) continue;
            ix = 0;
            ++iy;
        }
        return r;
    }

    public final double temperature() {
        return this.temperature;
    }
}

