/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Graphics;
import simulate.Phase;
import simulate.Potential;
import simulate.PotentialIdealGas;

public abstract class Space {
    public abstract int D();

    public void draw(Graphics g, int[] origin, double scale) {
    }

    public abstract Boundary makeBoundary(int var1);

    public abstract Coordinate makeCoordinate(Occupant var1);

    public abstract CoordinatePair makeCoordinatePair(Boundary var1);

    public Potential makePotential(Phase p) {
        if (p.boundary() instanceof Potential) {
            return (Potential)((Object)p.boundary());
        }
        return new PotentialIdealGas();
    }

    public abstract Vector makeVector();

    public abstract double sphereArea(double var1);

    public abstract double sphereVolume(double var1);

    static interface Occupant {
        public Coordinate coordinate();

        public double mass();

        public Phase parentPhase();

        public double rm();
    }

    public static abstract class Vector {
        public abstract void DE(double var1);

        public abstract void DE(Vector var1);

        public abstract void E(double var1);

        public abstract void E(int var1, double var2);

        public abstract void E(Vector var1);

        public abstract void Ea1Tv1(double var1, Vector var3);

        public abstract void ME(Vector var1);

        public abstract void PE(int var1, double var2);

        public abstract void PE(Vector var1);

        public abstract void PEa1Tv1(double var1, Vector var3);

        public final void PEa1Tv1(double[] a, Vector[] u) {
            int i = a.length - 1;
            while (i >= 0) {
                this.PEa1Tv1(a[i], u[i]);
                --i;
            }
        }

        public abstract void TE(double var1);

        public abstract void TE(int var1, double var2);

        public abstract void TE(Vector var1);

        public abstract double component(int var1);

        public abstract double dot(Vector var1);

        public abstract void setComponent(int var1, double var2);

        public abstract void setRandom(double var1);

        public abstract void setRandomCube();

        public abstract void setRandomSphere();

        public abstract double squared();

        public static Vector zero() {
            return null;
        }
    }

    public static abstract class Coordinate {
        protected final Occupant parent;

        Coordinate(Occupant p) {
            this.parent = p;
        }

        public abstract double kineticEnergy(double var1);

        public abstract Vector makeVector();

        public abstract Vector momentum();

        public abstract double momentum(int var1);

        public final Occupant parent() {
            return this.parent;
        }

        public final Phase parentPhase() {
            return this.parent.parentPhase();
        }

        public abstract Vector position();

        public abstract double position(int var1);

        public void scaleMomentum(double scale) {
            this.momentum().TE(scale);
        }
    }

    public static abstract class CoordinatePair
    implements Cloneable {
        public double r2;

        public CoordinatePair copy() {
            try {
                return (CoordinatePair)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public abstract Vector dr();

        public abstract double dr(int var1);

        public abstract double dv(int var1);

        public abstract void push(double var1);

        public final double r2() {
            return this.r2;
        }

        public abstract void reset();

        public abstract void reset(Coordinate var1, Coordinate var2);

        public abstract void setSeparation(double var1);

        public abstract double v2();

        public abstract double vDotr();
    }

    public static abstract class Boundary {
        public static final int NONE = 0;
        public static final int PERIODIC = 1;
        public static final int DEFAULT = 1;

        public abstract void centralImage(Vector var1);

        public abstract Vector dimensions();

        public abstract void draw(Graphics var1, int[] var2, double var3);

        public abstract double[][] getOverflowShifts(Vector var1, double var2);

        public abstract double[][] imageOrigins(int var1);

        public abstract void inflate(double var1);

        public abstract Vector randomPosition();

        public abstract double volume();
    }
}

