/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.AtomPair;
import simulate.PotentialHard;
import simulate.Simulation;

public class PotentialHardDisk
implements PotentialHard {
    protected double collisionDiameter;
    protected double sig2;
    Simulation parentSimulation;
    private double lastCollisionVirial = 0.0;

    public PotentialHardDisk(double d) {
        this.setCollisionDiameter(d);
    }

    public void bump(AtomPair pair) {
        double r2 = pair.r2();
        this.lastCollisionVirial = 2.0 / (pair.atom1().rm() + pair.atom2().rm()) * pair.vDotr();
        double factor = this.lastCollisionVirial / r2;
        pair.cPair.push(factor);
    }

    public double collisionTime(AtomPair pair) {
        double velocitySquared;
        double discriminant;
        double r2 = pair.r2();
        double bij = pair.vDotr();
        if (r2 < this.sig2) {
            return bij > 0.0 ? Double.MAX_VALUE : 0.0;
        }
        double time = Double.MAX_VALUE;
        if (bij < 0.0 && (discriminant = bij * bij - (velocitySquared = pair.v2()) * (r2 - this.sig2)) > 0.0) {
            time = (-bij - Math.sqrt(discriminant)) / velocitySquared;
        }
        return time;
    }

    public double energy(AtomPair pair) {
        return pair.r2() < this.sig2 ? Double.MAX_VALUE : 0.0;
    }

    public double energyLRC(int n1, int n2, double V) {
        return 0.0;
    }

    public double getCollisionDiameter() {
        return this.collisionDiameter;
    }

    public Simulation getParentSimulation() {
        return this.parentSimulation;
    }

    public final double lastCollisionVirial() {
        return this.lastCollisionVirial;
    }

    public boolean overlap(AtomPair pair) {
        return pair.r2() < this.sig2;
    }

    public void setCollisionDiameter(double c) {
        this.collisionDiameter = c;
        this.sig2 = c * c;
    }

    public void setParentSimulation(Simulation s) {
        this.parentSimulation = s;
    }
}

