/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.Beans;
import simulate.Atom;
import simulate.Potential;
import simulate.Potential2;
import simulate.PotentialHardDisk;

public class P2HardDisk
extends Potential2 {
    private double collisionDiameter = 3.5;
    private PotentialHardDisk onlyPotential;

    public P2HardDisk() {
        this.setSize(30, 30);
        this.nAtoms1 = 1;
        this.nAtoms2 = 1;
        this.onlyPotential = new PotentialHardDisk(this.collisionDiameter);
        this.potential = new Potential[this.nAtoms1][this.nAtoms2];
        this.potential[0][0] = this.onlyPotential;
        this.setCollisionDiameter(this.collisionDiameter);
    }

    public final double getCollisionDiameter() {
        return this.collisionDiameter;
    }

    public final Potential getPotential(Atom a1, Atom a2) {
        return this.onlyPotential;
    }

    public void paint(Graphics g) {
        int[] simulationPixelDimensions = new int[]{-1, -1};
        if (Beans.isDesignTime() && this.getParent() != null) {
            Container par = this.getParent();
            simulationPixelDimensions[0] = par.getSize().width;
            simulationPixelDimensions[1] = par.getSize().height;
            double scale = Math.max(simulationPixelDimensions[0], simulationPixelDimensions[1]);
            int moleculePixelDiameter = (int)(scale * this.collisionDiameter);
            g.setColor(Color.red);
            int moleculePixelPositionX = this.getLocation().x;
            int moleculePixelPositionY = this.getLocation().y;
            g.fillOval(0, 0, moleculePixelDiameter, moleculePixelDiameter);
        }
    }

    public final void setCollisionDiameter(double d) {
        this.collisionDiameter = d;
        this.onlyPotential.setCollisionDiameter(d);
        this.setPotentialCutoff(d);
    }
}

