/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import simulate.DisplayConfiguration;
import simulate.Meter;
import simulate.Molecule;
import simulate.Phase;
import simulate.Species;

public class MeterWidomInsertion
extends Meter {
    private int nInsert;
    private Species species;
    private Species.Agent speciesAgent;
    private Molecule molecule;
    private boolean residual;
    private DisplayConfiguration display;

    public MeterWidomInsertion() {
        this.setLabel("exp(\u03bc/kT)");
        this.nInsert = 100;
        this.setResidual(true);
    }

    public MeterWidomInsertion(Species s, DisplayConfiguration d) {
        this();
        this.display = d;
        this.setSpecies(s);
    }

    public double currentValue() {
        double sum = 0.0;
        this.phase.addMolecule(this.molecule, this.speciesAgent);
        this.molecule.firstAtom().setColor(Color.red);
        int i = this.nInsert;
        while (i > 0) {
            double u;
            this.molecule.translateTo(this.phase.randomPosition());
            if (this.display != null && i % 10 == 0) {
                this.display.repaint();
            }
            if ((u = this.phase.potentialEnergy.currentValue(this.molecule)) < Double.MAX_VALUE) {
                sum += Math.exp(-u / this.phase.integrator().temperature());
            }
            --i;
        }
        this.phase.deleteMolecule(this.molecule);
        if (!this.residual) {
            sum *= (double)this.phase.moleculeCount / this.phase.volume();
        }
        return sum / (double)this.nInsert;
    }

    public int getNInsert() {
        return this.nInsert;
    }

    public Species getSpecies(Species s) {
        return this.species;
    }

    public boolean isResidual() {
        return this.residual;
    }

    public void setNInsert(int n) {
        this.nInsert = n;
    }

    public void setPhase(Phase p) {
        super.setPhase(p);
        if (this.species != null) {
            this.speciesAgent = this.species.getAgent(this.phase);
        }
    }

    public void setResidual(boolean b) {
        this.residual = b;
        this.reset();
    }

    public void setSpecies(Species s) {
        this.species = s;
        this.molecule = this.species.getMolecule();
        if (this.phase != null) {
            this.speciesAgent = this.species.getAgent(this.phase);
        }
    }
}

