/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Container;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import simulate.Atom;
import simulate.AtomType;
import simulate.ColorScheme;
import simulate.ConfigurationMolecule;
import simulate.DisplayConfiguration;
import simulate.Molecule;
import simulate.Phase;
import simulate.Simulation;

public abstract class Species
extends Container {
    private int nMolecules;
    String name;
    public ColorScheme colorScheme;
    int speciesIndex;
    protected int atomsPerMolecule;
    Simulation parentSimulation;
    Hashtable agents = new Hashtable();
    private final transient int[] shiftOrigin = new int[2];
    public ConfigurationMolecule configurationMolecule;
    Species previousSpecies;
    Species nextSpecies;
    private final Reservoir reservoir = new Reservoir();
    private final Random rand = new Random();

    public void add(ColorScheme cs) {
        this.colorScheme = cs;
        if (this.parentSimulation == null) {
            return;
        }
        Enumeration e = this.agents.elements();
        while (e.hasMoreElements()) {
            Agent a = (Agent)e.nextElement();
            a.add(cs);
        }
    }

    public void add(ConfigurationMolecule cm) {
        cm.setParentSpecies(this);
        this.configurationMolecule = cm;
        if (this.parentSimulation == null) {
            return;
        }
        Enumeration e = this.agents.keys();
        while (e.hasMoreElements()) {
            Phase p = (Phase)e.nextElement();
            cm.initializeCoordinates(p);
        }
    }

    public final Agent getAgent(Phase p) {
        return (Agent)this.agents.get(p);
    }

    public int getAtomsPerMolecule() {
        return this.atomsPerMolecule;
    }

    public final Molecule getMolecule() {
        if (this.reservoir.isEmpty()) {
            Molecule m = this.makeMolecule();
            this.reservoir.addNewMolecule(m);
        }
        return this.reservoir.nextMolecule();
    }

    public int getNMolecules() {
        return this.nMolecules;
    }

    public final String getName() {
        return this.name;
    }

    public final int getSpeciesIndex() {
        return this.speciesIndex;
    }

    public Agent makeAgent(Phase p) {
        Agent a = new Agent(p);
        a.setNMolecules(this.nMolecules);
        a.add(this.colorScheme);
        this.agents.put(p, a);
        return a;
    }

    private Molecule makeMolecule() {
        return this.makeMolecule(null);
    }

    protected abstract Molecule makeMolecule(Phase var1);

    public final Species nextSpecies() {
        return this.nextSpecies;
    }

    public final Simulation parentSimulation() {
        return this.parentSimulation;
    }

    public final Species previousSpecies() {
        return this.previousSpecies;
    }

    public final Reservoir reservoir() {
        return this.reservoir;
    }

    public void setAtomsPerMolecule(int na) {
        this.atomsPerMolecule = na;
        if (this.parentSimulation == null) {
            return;
        }
        Enumeration e = this.agents.elements();
        while (e.hasMoreElements()) {
            Agent a = (Agent)e.nextElement();
            a.setNMolecules(a.nMolecules);
        }
    }

    public void setNMolecules(int n) {
        this.nMolecules = n;
        if (this.parentSimulation == null) {
            return;
        }
        Enumeration e = this.agents.elements();
        while (e.hasMoreElements()) {
            Agent a = (Agent)e.nextElement();
            a.setNMolecules(n);
        }
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setNextSpecies(Species s) {
        this.nextSpecies = s;
        if (s != null) {
            s.previousSpecies = this;
        }
    }

    public final void setSpeciesIndex(int index) {
        this.speciesIndex = index;
    }

    public class Agent {
        public Phase parentPhase;
        protected int nMolecules;
        Agent nextSpecies;
        Agent previousSpecies;
        protected Molecule firstMolecule;
        protected Molecule lastMolecule;
        public ColorScheme colorScheme;

        public Agent(Phase p) {
            this.parentPhase = p;
        }

        public void add(ColorScheme cs) {
            this.colorScheme = cs;
            Atom a = this.firstAtom();
            while (a != this.terminationAtom()) {
                this.colorScheme.initializeAtomColor(a);
                a = a.nextAtom();
            }
        }

        public final void addMolecule(Molecule m) {
            if (this.nMolecules > 0) {
                m.setNextMolecule(this.lastMolecule.nextMolecule());
                this.lastMolecule.setNextMolecule(m);
                this.lastMolecule = m;
            } else {
                this.firstMolecule = m;
                this.lastMolecule = m;
                m.setNextMolecule(null);
                Agent s = this.nextSpecies();
                while (s != null) {
                    if (s.firstMolecule() != null) {
                        m.setNextMolecule(s.firstMolecule());
                        break;
                    }
                    s = s.nextSpecies();
                }
                m.clearPreviousMolecule();
                Agent s2 = this.previousSpecies();
                while (s2 != null) {
                    if (s2.lastMolecule() != null) {
                        s2.lastMolecule.setNextMolecule(m);
                        break;
                    }
                    s2 = s2.previousSpecies();
                }
            }
            ++this.nMolecules;
            this.colorScheme.initializeMoleculeColor(m);
        }

        public ColorScheme colorScheme() {
            return this.colorScheme;
        }

        public final void deleteMolecule(Molecule m) {
            if (m.parentSpecies != Species.this) {
                System.out.println("Error:  attempt to delete molecule from incorrect species");
                return;
            }
            Molecule next = m.nextMolecule();
            Molecule previous = m.previousMolecule();
            if (m == this.firstMolecule) {
                this.firstMolecule = this.nMolecules == 1 ? null : next;
            }
            if (m == this.lastMolecule) {
                this.lastMolecule = this.nMolecules == 1 ? null : previous;
            }
            if (previous != null) {
                previous.setNextMolecule(next);
            } else if (next != null) {
                next.clearPreviousMolecule();
            }
            --this.nMolecules;
            m.setNextMolecule(null);
            m.clearPreviousMolecule();
        }

        public void draw(Graphics g, int[] origin, double scale) {
            double toPixels = scale * DisplayConfiguration.SIM2PIXELS;
            Atom nextSpeciesAtom = this.terminationAtom();
            Atom a = this.firstAtom();
            while (a != nextSpeciesAtom) {
                this.parentPhase.boundary().centralImage(a.coordinate.position());
                a.draw(g, origin, scale);
                a = a.nextAtom();
            }
            if (DisplayConfiguration.DRAW_OVERFLOW) {
                Atom a2 = this.firstAtom();
                while (a2 != nextSpeciesAtom) {
                    if (a2.type instanceof AtomType.Disk) {
                        double[][] shifts = a2.parentMolecule.parentPhase().boundary().getOverflowShifts(a2.coordinate.position(), ((AtomType.Disk)a2.type).radius());
                        int i = 0;
                        while (i < shifts.length) {
                            ((Species)Species.this).shiftOrigin[0] = origin[0] + (int)(toPixels * shifts[i][0]);
                            ((Species)Species.this).shiftOrigin[1] = origin[1] + (int)(toPixels * shifts[i][1]);
                            a2.draw(g, Species.this.shiftOrigin, scale);
                            ++i;
                        }
                    }
                    a2 = a2.nextAtom();
                }
            }
        }

        public final Atom firstAtom() {
            return this.firstMolecule == null ? null : this.firstMolecule.firstAtom();
        }

        public final Molecule firstMolecule() {
            return this.firstMolecule;
        }

        public final int getNMolecules() {
            return this.nMolecules;
        }

        public final Atom lastAtom() {
            return this.lastMolecule == null ? null : this.lastMolecule.lastAtom();
        }

        public final Molecule lastMolecule() {
            return this.lastMolecule;
        }

        public final Agent nextSpecies() {
            return this.nextSpecies;
        }

        public final Phase parentPhase() {
            return this.parentPhase;
        }

        public final Species parentSpecies() {
            return Species.this;
        }

        public final Agent previousSpecies() {
            return this.previousSpecies;
        }

        public final Molecule randomMolecule() {
            int i = (int)(Species.this.rand.nextDouble() * (double)this.nMolecules);
            Molecule m = this.firstMolecule;
            int j = i;
            while (--j >= 0) {
                m = m.nextMolecule();
            }
            return m;
        }

        public void setBounds(int x, int y, int width, int height) {
        }

        public void setNMolecules(int n) {
            Molecule previous = null;
            Molecule next = null;
            if (this.firstMolecule != null) {
                previous = this.firstMolecule.previousMolecule();
            }
            if (this.lastMolecule != null) {
                next = this.lastMolecule.nextMolecule();
            }
            this.nMolecules = n;
            if (this.nMolecules == 0) {
                this.firstMolecule = null;
                this.lastMolecule = null;
                return;
            }
            this.lastMolecule = this.firstMolecule = Species.this.makeMolecule(this.parentPhase);
            int i = 1;
            while (i < this.nMolecules) {
                this.lastMolecule.setNextMolecule(Species.this.makeMolecule(this.parentPhase));
                this.lastMolecule = this.lastMolecule.nextMolecule();
                ++i;
            }
            if (previous != null) {
                previous.setNextMolecule(this.firstMolecule);
            }
            this.lastMolecule.setNextMolecule(next);
            this.parentPhase.updateCounts();
            this.parentPhase.configuration.initializeCoordinates();
            this.parentPhase.iterator.reset();
        }

        public final void setNextSpecies(Agent s) {
            this.nextSpecies = s;
            Molecule last = this.lastMolecule();
            if (s == null) {
                if (last != null) {
                    last.setNextMolecule(null);
                }
                return;
            }
            s.previousSpecies = this;
            if (last != null) {
                last.setNextMolecule(s.firstMolecule);
            }
        }

        public final Atom terminationAtom() {
            Atom last = this.lastAtom();
            return last == null ? null : last.nextAtom();
        }

        public final Molecule terminationMolecule() {
            return this.lastMolecule == null ? null : this.lastMolecule.nextMolecule();
        }
    }

    protected static final class Reservoir
    implements Molecule.Container {
        private Molecule next;

        protected Reservoir() {
        }

        public void addMolecule(Molecule m) {
            m.container.removeMolecule(m);
            m.setNextMolecule(this.next);
            m.setContainer(this);
            this.next = m;
        }

        private void addNewMolecule(Molecule m) {
            m.setNextMolecule(this.next);
            m.setContainer(this);
            this.next = m;
        }

        public boolean isEmpty() {
            return this.next == null;
        }

        public Molecule nextMolecule() {
            return this.next;
        }

        public void removeMolecule(Molecule m) {
            if (m != this.next) {
                System.out.println("Error:  removal of inappropriate molecule from reservoir");
            }
            if (this.next != null) {
                this.next = this.next.nextMolecule();
            }
        }
    }
}

