/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Rectangle;
import simulate.Atom;
import simulate.AtomType;
import simulate.ConfigurationMolecule;
import simulate.DisplayConfiguration;
import simulate.Molecule;
import simulate.Space;

public class ConfigurationMoleculeWallsParallel
extends ConfigurationMolecule {
    private int angle;
    private boolean horizontal;
    private boolean vertical;
    private boolean longWall;
    private double temperature = 300.0;
    private double placement;

    public ConfigurationMoleculeWallsParallel() {
        this.setAngle(0);
        this.setLongWall(false);
        this.setPlacement(0.0);
    }

    protected void computeDimensions() {
        if (this.parentSpecies() == null) {
            return;
        }
        Molecule m = this.parentSpecies.getMolecule();
        if (this.horizontal) {
            this.dim[0] = Double.MAX_VALUE;
            this.dim[1] = 0.0;
        } else if (this.vertical) {
            this.dim[0] = 0.0;
            this.dim[1] = Double.MAX_VALUE;
        }
    }

    public final int getAngle() {
        return this.angle;
    }

    public final double getPlacement() {
        return this.placement;
    }

    public final double getTemperature() {
        return this.temperature;
    }

    public void initializeCoordinates(Molecule m) {
        double wh;
        double xyNext;
        double delta;
        double y;
        double x;
        Rectangle rect = this.parentSpecies.getBounds();
        Space.Vector d = m.parentPhase().dimensions();
        double h = d.component(1);
        double w = d.component(0);
        if (this.longWall) {
            if (this.horizontal) {
                x = 0.0;
                y = this.placement * d.component(1);
                w = Double.MAX_VALUE;
            } else {
                x = this.placement * d.component(0);
                y = 0.0;
                h = Double.MAX_VALUE;
            }
        } else {
            x = (double)this.getBounds().x / DisplayConfiguration.SIM2PIXELS;
            y = (double)this.getBounds().y / DisplayConfiguration.SIM2PIXELS;
            if (this.horizontal) {
                w = d.component(0) - x;
            } else {
                h = d.component(1) - y;
            }
        }
        int i = 0;
        if (this.horizontal) {
            delta = (h - y) / (double)(m.atomCount - 1);
            i = 1;
            xyNext = y;
            wh = w;
        } else {
            delta = (w - x) / (double)(m.atomCount - 1);
            i = 0;
            xyNext = x;
            wh = h;
        }
        Atom a = m.firstAtom();
        while (a != m.terminationAtom()) {
            Space.Vector r = a.coordinate.position();
            a.coordinate.momentum().E(0.0);
            r.setComponent(i, xyNext);
            xyNext += delta;
            ((AtomType.Wall)a.type).setLength(wh);
            ((AtomType.Wall)a.type).setAngle(this.angle);
            ((AtomType.Wall)a.type).setTemperature(this.temperature);
            a = a.nextAtom();
        }
    }

    public final boolean isLongWall() {
        return this.longWall;
    }

    public final void setAngle(int t) {
        t = Math.abs(t) > 45 ? 90 : 0;
        this.angle = t <= 360 ? t : t % 360;
        this.horizontal = this.angle == 0 || Math.abs(this.angle) == 180;
        this.vertical = Math.abs(this.angle) == 90 || Math.abs(this.angle) == 270;
        this.initializeCoordinates();
    }

    public final void setLongWall(boolean s) {
        this.longWall = s;
        this.initializeCoordinates();
    }

    public final void setPlacement(double p) {
        this.placement = p;
    }

    public final void setTemperature(double t) {
        this.temperature = t;
        this.initializeCoordinates();
    }
}

