/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import simulate.AtomType;
import simulate.ColorSchemeNull;
import simulate.ConfigurationMoleculeWallsParallel;
import simulate.Molecule;
import simulate.Phase;
import simulate.Species;

public class SpeciesWalls
extends Species {
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public AtomType.Wall[] protoType;

    public SpeciesWalls() {
        this(1, 1, Double.MAX_VALUE, 0);
    }

    public SpeciesWalls(int nM, int nA, double length, int angle) {
        this.protoType = new AtomType.Wall[nA];
        int i = 0;
        while (i < nA) {
            this.protoType[i] = new AtomType.Wall(1.0, Color.black, length, angle);
            ++i;
        }
        this.setSpeciesIndex(1);
        this.atomsPerMolecule = nA;
        this.setNMolecules(nM);
        this.colorScheme = new ColorSchemeNull();
        this.add(new ConfigurationMoleculeWallsParallel());
    }

    public SpeciesWalls(int nM, AtomType.Wall[] type) {
        this.setSpeciesIndex(1);
        this.protoType = type;
        this.atomsPerMolecule = type.length;
        this.colorScheme = new ColorSchemeNull();
        this.add(new ConfigurationMoleculeWallsParallel());
    }

    protected Molecule makeMolecule(Phase phase) {
        return new Molecule(this, phase, this.protoType);
    }
}

