/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Button;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import simulate.Atom;
import simulate.Controller;
import simulate.IntegrationIntervalEvent;
import simulate.IntegrationIntervalListener;
import simulate.Meter;
import simulate.Phase;
import simulate.Simulation;

public abstract class Integrator
extends Container
implements Observer,
Serializable,
MouseListener,
Runnable {
    public Thread runner;
    public boolean running = false;
    protected int maxSteps = Integer.MAX_VALUE;
    Phase firstPhase;
    Phase[] phase;
    int phaseCount = 0;
    int phaseCountMax = 1;
    protected int sleepPeriod = 10;
    protected transient Vector listeners = null;
    private Vector integrationIntervalListeners = new Vector();
    int integrationInterval = 10;
    int integrationCount = 0;
    double drawTimeStep = 5.0E-4;
    boolean doSleep = true;
    private int neighborListUpdateInterval = Integer.MAX_VALUE;
    public Controller parentController;
    public double temperature = 300.0;
    public boolean isothermal = false;

    public Integrator() {
        this.phase = new Phase[this.phaseCountMax];
    }

    public synchronized void addIntegrationIntervalListener(IntegrationIntervalListener iil) {
        this.integrationIntervalListeners.addElement(iil);
    }

    protected void deployAgents() {
        Phase p = this.firstPhase;
        while (p != null) {
            Atom a = p.firstAtom();
            while (a != null) {
                a.setIntegratorAgent(this.makeAgent(a));
                a = a.nextAtom();
            }
            p = p.nextPhase();
        }
    }

    public abstract void doStep(double var1);

    public void fireIntegrationIntervalEvent(IntegrationIntervalEvent iie) {
        Vector currentListeners = null;
        Integrator integrator = this;
        synchronized (integrator) {
            currentListeners = (Vector)this.integrationIntervalListeners.clone();
        }
        int i = 0;
        while (i < currentListeners.size()) {
            IntegrationIntervalListener listener = (IntegrationIntervalListener)currentListeners.elementAt(i);
            listener.integrationIntervalAction(iie);
            ++i;
        }
    }

    public final double getDrawTimeStep() {
        return this.drawTimeStep;
    }

    public final int getIntegrationInterval() {
        return this.integrationInterval;
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public final int getSleepPeriod() {
        return this.sleepPeriod;
    }

    public final double getTemperature() {
        return this.temperature;
    }

    public abstract void initialize();

    public boolean isDoSleep() {
        return this.doSleep;
    }

    public boolean isIsothermal() {
        return this.isothermal;
    }

    public abstract Agent makeAgent(Atom var1);

    public void mouseClicked(MouseEvent evt) {
        if (evt.getSource() instanceof Button) {
            Button button = (Button)evt.getSource();
            if (this.runner == null) {
                this.initialize();
                this.runner = new Thread(this);
                this.runner.start();
                this.running = true;
                button.setLabel("Pause");
            } else if (this.running) {
                this.running = false;
                this.runner.suspend();
                button.setLabel("Continue");
            } else {
                this.runner.resume();
                this.running = true;
                button.setLabel("Pause");
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void registerPhase(Phase p) {
        if (this.phaseCount == this.phaseCountMax) {
            return;
        }
        int i = 0;
        while (i < this.phaseCount) {
            if (this.phase[i] == p) {
                return;
            }
            ++i;
        }
        this.phase[this.phaseCount] = p;
        ++this.phaseCount;
        this.firstPhase = this.phase[0];
        Meter m = p.firstMeter;
        while (m != null) {
            this.addIntegrationIntervalListener(m);
            m = m.nextMeter();
        }
    }

    public synchronized void removeIntegrationIntervalListener(IntegrationIntervalListener iil) {
        this.integrationIntervalListeners.removeElement(iil);
    }

    public void run() {
        boolean ic = false;
        int nSteps = 0;
        int iieCount = this.integrationInterval;
        while (nSteps < this.maxSteps) {
            this.doStep(this.drawTimeStep);
            if (--iieCount == 0) {
                this.fireIntegrationIntervalEvent(new IntegrationIntervalEvent(this, this.firstPhase));
                iieCount = this.integrationInterval;
            }
            if (this.doSleep) {
                try {
                    Thread.sleep(this.sleepPeriod);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++nSteps;
        }
        System.exit(0);
    }

    public void setDoSleep(boolean b) {
        this.doSleep = b;
    }

    public final void setDrawTimeStep(double t) {
        this.drawTimeStep = t;
    }

    public final void setITemperature(int t) {
        this.temperature = t;
    }

    public final void setIntegrationInterval(int interval) {
        this.integrationInterval = interval;
    }

    public void setIsothermal(boolean b) {
        this.isothermal = b;
    }

    public void setMaxSteps(int m) {
        this.maxSteps = m;
    }

    public final void setSleepPeriod(int s) {
        this.sleepPeriod = s;
    }

    public final void setTemperature(double t) {
        this.temperature = t;
    }

    public final Simulation simulation() {
        return this.parentController.parentSimulation;
    }

    public void start() {
    }

    public void stop() {
        if (this.runner != null) {
            this.runner.stop();
            this.runner = null;
        }
    }

    public void update(Observable o, Object arg) {
    }

    static interface Agent {
    }
}

