/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.ConfigurationMolecule;
import simulate.Molecule;
import simulate.Simulation;
import simulate.Space;
import simulate.Space2D;
import simulate.Species;

public class ConfigurationMoleculeLinear
extends ConfigurationMolecule {
    private double bondLength = 0.02;
    private Space.Vector orientation;
    private double[] angle = new double[Simulation.D];

    protected void computeDimensions() {
    }

    public double getAngle(int i) {
        return this.angle[i];
    }

    public double getBondLength() {
        return this.bondLength;
    }

    public void initializeCoordinates(Molecule m) {
        Simulation cfr_ignored_0 = m.parentSpecies.parentSimulation;
        Space.Vector OldCOM = Simulation.space.makeVector();
        OldCOM.E(m.COM());
        double xNext = 0.0;
        Atom a = m.firstAtom();
        while (a != m.terminationAtom()) {
            a.translateTo(OldCOM);
            a.translateBy(xNext, this.orientation);
            xNext += this.bondLength;
            a = a.nextAtom();
        }
        m.translateTo(OldCOM);
    }

    public void setAngle(int i, double t) {
        this.angle[i] = Math.PI * t / 180.0;
        switch (Simulation.D) {
            case 1: {
                return;
            }
            case 2: {
                this.setOrientation(new Space2D.Vector(Math.cos(this.angle[0]), Math.sin(this.angle[0])));
                return;
            }
        }
    }

    public void setBondLength(double b) {
        this.bondLength = b;
        this.computeDimensions();
    }

    public void setOrientation(Space.Vector e) {
        this.orientation.E(e);
    }

    public void setParentSpecies(Species s) {
        this.parentSpecies = s;
        Simulation cfr_ignored_0 = s.parentSimulation;
        this.orientation = Simulation.space.makeVector();
    }
}

