/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import simulate.Atom;
import simulate.IntegrationIntervalEvent;
import simulate.Integrator;
import simulate.Space2D;

public class IntegratorRectangleRule
extends Integrator {
    private double[] xMin = new double[2];
    private double[] xMax = new double[2];
    private double[] deltaX = new double[2];
    private double[][] x;
    private int nPointsD = 3;
    private Space2D.Vector[] positions;
    private int D;
    private int iieCount;
    private int totalCount = 0;
    private int totalSteps;
    private boolean delay = false;
    public double current = -1.0;

    public void doStep(double dummy) {
    }

    public int getN() {
        return this.nPointsD;
    }

    private void increment() {
        ++this.totalCount;
        while (this.paused) {
            this.doWait();
        }
        if (--this.iieCount == 0) {
            this.fireIntegrationIntervalEvent(new IntegrationIntervalEvent(this, this.firstPhase));
            this.iieCount = this.integrationInterval;
        }
        if (this.delay) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
            this.fireIntegrationIntervalEvent(new IntegrationIntervalEvent(this, this.firstPhase));
        }
        Thread.yield();
    }

    public void initialize() {
        int nAtoms = this.firstPhase.atomCount();
        this.positions = new Space2D.Vector[nAtoms];
        this.D = 2 * nAtoms;
        this.setN(this.nPointsD);
        int delC = 0;
        if (nAtoms > 1) {
            delC = 255 / (nAtoms - 1);
        }
        int Rvalue = 255;
        int i = 0;
        Atom a = this.firstPhase.firstAtom();
        while (a != null) {
            a.setColor(new Color(Rvalue, 0, 255 - Rvalue));
            Rvalue -= delC;
            this.positions[i] = (Space2D.Vector)a.position();
            this.positions[i].x = this.x[0][0];
            this.positions[i].y = this.x[0][1];
            ++i;
            a = a.nextAtom();
        }
        this.totalCount = 0;
        this.totalSteps = (int)Math.pow(this.nPointsD, 2 * nAtoms);
    }

    public boolean isDelayed() {
        return this.delay;
    }

    public Integrator.Agent makeAgent(Atom a) {
        return null;
    }

    public int percentComplete() {
        return (int)(100.0 * (double)this.totalCount / (double)this.totalSteps);
    }

    private double rectangleRecurse(int k) {
        double delX;
        boolean doX;
        Space2D.Vector r;
        double sum = 0.0;
        if (k % 2 == 0) {
            r = this.positions[k >> 1];
            doX = true;
            delX = this.deltaX[0];
        } else {
            r = this.positions[k - 1 >> 1];
            doX = false;
            delX = this.deltaX[1];
        }
        int i = 0;
        while (i < this.nPointsD) {
            if (doX) {
                r.x = this.x[i][0];
            } else {
                r.y = this.x[i][1];
            }
            if (k == this.D - 1) {
                this.current = Math.exp(-this.firstPhase.potentialEnergy.currentValue() / this.temperature);
                sum += this.current;
                this.increment();
            } else {
                sum += this.rectangleRecurse(k + 1);
            }
            ++i;
        }
        return sum * delX;
    }

    public void run() {
        this.iieCount = this.integrationInterval;
        this.rectangleRecurse(0);
        this.fireIntegrationIntervalEvent(new IntegrationIntervalEvent(this, this.firstPhase));
        this.parentController.reset();
        this.runner = new Thread(this);
    }

    public void setDelayed(boolean d) {
        this.delay = d;
    }

    public void setN(int n) {
        boolean reInitialize = this.nPointsD != n;
        this.nPointsD = n;
        if (reInitialize) {
            this.initialize();
        }
        this.xMax[0] = this.firstPhase.dimensions().component(0);
        this.xMax[1] = this.firstPhase.dimensions().component(1);
        this.deltaX[0] = this.xMax[0] / (double)n;
        this.deltaX[1] = this.xMax[1] / (double)n;
        this.x = new double[2 * this.firstPhase.atomCount()][2];
        int i = 0;
        while (i < n) {
            this.x[i][0] = ((double)i + 0.5) * this.deltaX[0];
            this.x[i][1] = ((double)i + 0.5) * this.deltaX[1];
            ++i;
        }
    }
}

